/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.models.ResponseError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.implementation.models.AcsMessageChannelEventError;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

@Deprecated
public class AcsMessageEventData
implements JsonSerializable<AcsMessageEventData> {
    private String from;
    private String to;
    private OffsetDateTime receivedTimestamp;
    private AcsMessageChannelEventError error;

    public String getFrom() {
        return this.from;
    }

    public AcsMessageEventData setFrom(String from) {
        this.from = from;
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public AcsMessageEventData setTo(String to) {
        this.to = to;
        return this;
    }

    public OffsetDateTime getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public AcsMessageEventData setReceivedTimestamp(OffsetDateTime receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
        return this;
    }

    public ResponseError getError() {
        return new ResponseError(this.error.getChannelCode(), this.error.getChannelMessage());
    }

    void setError(AcsMessageChannelEventError error) {
        this.error = error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("from", this.from);
        jsonWriter.writeStringField("to", this.to);
        jsonWriter.writeStringField("receivedTimestamp", this.receivedTimestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.receivedTimestamp));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static AcsMessageEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsMessageEventData)jsonReader.readObject(reader -> {
            AcsMessageEventData deserializedAcsMessageEventData = new AcsMessageEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("from".equals(fieldName)) {
                    deserializedAcsMessageEventData.from = reader.getString();
                    continue;
                }
                if ("to".equals(fieldName)) {
                    deserializedAcsMessageEventData.to = reader.getString();
                    continue;
                }
                if ("receivedTimestamp".equals(fieldName)) {
                    deserializedAcsMessageEventData.receivedTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedAcsMessageEventData.error = AcsMessageChannelEventError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsMessageEventData;
        });
    }

    public AcsMessageEventData setError(ResponseError error) {
        this.error = new AcsMessageChannelEventError().setChannelCode(error.getCode()).setChannelMessage(error.getMessage());
        return this;
    }
}

