/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class StorageTaskAssignmentQueuedEventData
implements JsonSerializable<StorageTaskAssignmentQueuedEventData> {
    private OffsetDateTime queuedOn;
    private String taskExecutionId;

    public OffsetDateTime getQueuedOn() {
        return this.queuedOn;
    }

    public StorageTaskAssignmentQueuedEventData setQueuedOn(OffsetDateTime queuedOn) {
        this.queuedOn = queuedOn;
        return this;
    }

    public String getTaskExecutionId() {
        return this.taskExecutionId;
    }

    public StorageTaskAssignmentQueuedEventData setTaskExecutionId(String taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queuedDateTime", this.queuedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.queuedOn));
        jsonWriter.writeStringField("taskExecutionId", this.taskExecutionId);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskAssignmentQueuedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskAssignmentQueuedEventData)jsonReader.readObject(reader -> {
            StorageTaskAssignmentQueuedEventData deserializedStorageTaskAssignmentQueuedEventData = new StorageTaskAssignmentQueuedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queuedDateTime".equals(fieldName)) {
                    deserializedStorageTaskAssignmentQueuedEventData.queuedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("taskExecutionId".equals(fieldName)) {
                    deserializedStorageTaskAssignmentQueuedEventData.taskExecutionId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskAssignmentQueuedEventData;
        });
    }
}

