/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class PolicyInsightsPolicyStateCreatedEventData
implements JsonSerializable<PolicyInsightsPolicyStateCreatedEventData> {
    private OffsetDateTime timestamp;
    private String policyAssignmentId;
    private String policyDefinitionId;
    private String policyDefinitionReferenceId;
    private String complianceState;
    private String subscriptionId;
    private String complianceReasonCode;

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public PolicyInsightsPolicyStateCreatedEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public String getPolicyAssignmentId() {
        return this.policyAssignmentId;
    }

    public PolicyInsightsPolicyStateCreatedEventData setPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    public String getPolicyDefinitionId() {
        return this.policyDefinitionId;
    }

    public PolicyInsightsPolicyStateCreatedEventData setPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    public String getPolicyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    public PolicyInsightsPolicyStateCreatedEventData setPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    public String getComplianceState() {
        return this.complianceState;
    }

    public PolicyInsightsPolicyStateCreatedEventData setComplianceState(String complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public PolicyInsightsPolicyStateCreatedEventData setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String getComplianceReasonCode() {
        return this.complianceReasonCode;
    }

    public PolicyInsightsPolicyStateCreatedEventData setComplianceReasonCode(String complianceReasonCode) {
        this.complianceReasonCode = complianceReasonCode;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeStringField("complianceState", this.complianceState);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("complianceReasonCode", this.complianceReasonCode);
        return jsonWriter.writeEndObject();
    }

    public static PolicyInsightsPolicyStateCreatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyInsightsPolicyStateCreatedEventData)jsonReader.readObject(reader -> {
            PolicyInsightsPolicyStateCreatedEventData deserializedPolicyInsightsPolicyStateCreatedEventData = new PolicyInsightsPolicyStateCreatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateCreatedEventData.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("policyAssignmentId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateCreatedEventData.policyAssignmentId = reader.getString();
                    continue;
                }
                if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateCreatedEventData.policyDefinitionId = reader.getString();
                    continue;
                }
                if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateCreatedEventData.policyDefinitionReferenceId = reader.getString();
                    continue;
                }
                if ("complianceState".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateCreatedEventData.complianceState = reader.getString();
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateCreatedEventData.subscriptionId = reader.getString();
                    continue;
                }
                if ("complianceReasonCode".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateCreatedEventData.complianceReasonCode = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyInsightsPolicyStateCreatedEventData;
        });
    }
}

