/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.DeviceLifeCycleEventProperties;
import com.azure.messaging.eventgrid.systemevents.DeviceTwinInfo;
import java.io.IOException;

public final class IotHubDeviceDeletedEventData
extends DeviceLifeCycleEventProperties {
    @Override
    public IotHubDeviceDeletedEventData setDeviceId(String deviceId) {
        super.setDeviceId(deviceId);
        return this;
    }

    @Override
    public IotHubDeviceDeletedEventData setHubName(String hubName) {
        super.setHubName(hubName);
        return this;
    }

    @Override
    public IotHubDeviceDeletedEventData setTwin(DeviceTwinInfo twin) {
        super.setTwin(twin);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceId", this.getDeviceId());
        jsonWriter.writeStringField("hubName", this.getHubName());
        jsonWriter.writeJsonField("twin", (JsonSerializable)this.getTwin());
        return jsonWriter.writeEndObject();
    }

    public static IotHubDeviceDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (IotHubDeviceDeletedEventData)jsonReader.readObject(reader -> {
            IotHubDeviceDeletedEventData deserializedIotHubDeviceDeletedEventData = new IotHubDeviceDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceId".equals(fieldName)) {
                    deserializedIotHubDeviceDeletedEventData.setDeviceId(reader.getString());
                    continue;
                }
                if ("hubName".equals(fieldName)) {
                    deserializedIotHubDeviceDeletedEventData.setHubName(reader.getString());
                    continue;
                }
                if ("twin".equals(fieldName)) {
                    deserializedIotHubDeviceDeletedEventData.setTwin(DeviceTwinInfo.fromJson(reader));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIotHubDeviceDeletedEventData;
        });
    }
}

