/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsRouterJobEventData;
import com.azure.messaging.eventgrid.systemevents.AcsRouterJobStatus;
import com.azure.messaging.eventgrid.systemevents.AcsRouterWorkerSelector;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class AcsRouterJobReceivedEventData
extends AcsRouterJobEventData {
    private AcsRouterJobStatus jobStatus;
    private String classificationPolicyId;
    private Integer priority;
    private List<AcsRouterWorkerSelector> requestedWorkerSelectors;
    private OffsetDateTime scheduledOn;
    private boolean unavailableForMatching;

    public AcsRouterJobStatus getJobStatus() {
        return this.jobStatus;
    }

    public AcsRouterJobReceivedEventData setJobStatus(AcsRouterJobStatus jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    public String getClassificationPolicyId() {
        return this.classificationPolicyId;
    }

    public AcsRouterJobReceivedEventData setClassificationPolicyId(String classificationPolicyId) {
        this.classificationPolicyId = classificationPolicyId;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public AcsRouterJobReceivedEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public List<AcsRouterWorkerSelector> getRequestedWorkerSelectors() {
        return this.requestedWorkerSelectors;
    }

    public AcsRouterJobReceivedEventData setRequestedWorkerSelectors(List<AcsRouterWorkerSelector> requestedWorkerSelectors) {
        this.requestedWorkerSelectors = requestedWorkerSelectors;
        return this;
    }

    public OffsetDateTime getScheduledOn() {
        return this.scheduledOn;
    }

    public AcsRouterJobReceivedEventData setScheduledOn(OffsetDateTime scheduledOn) {
        this.scheduledOn = scheduledOn;
        return this;
    }

    public Boolean isUnavailableForMatching() {
        return this.unavailableForMatching;
    }

    public AcsRouterJobReceivedEventData setUnavailableForMatching(Boolean unavailableForMatching) {
        this.unavailableForMatching = unavailableForMatching;
        return this;
    }

    @Override
    public AcsRouterJobReceivedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    @Override
    public AcsRouterJobReceivedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    @Override
    public AcsRouterJobReceivedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public AcsRouterJobReceivedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    @Override
    public AcsRouterJobReceivedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    @Override
    public AcsRouterJobReceivedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", this.getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", this.getJobId());
        jsonWriter.writeStringField("channelReference", this.getChannelReference());
        jsonWriter.writeStringField("channelId", this.getChannelId());
        jsonWriter.writeStringField("queueId", this.getQueueId());
        jsonWriter.writeBooleanField("unavailableForMatching", this.unavailableForMatching);
        jsonWriter.writeStringField("jobStatus", this.jobStatus == null ? null : this.jobStatus.toString());
        jsonWriter.writeStringField("classificationPolicyId", this.classificationPolicyId);
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeArrayField("requestedWorkerSelectors", this.requestedWorkerSelectors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("scheduledOn", this.scheduledOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledOn));
        return jsonWriter.writeEndObject();
    }

    public static AcsRouterJobReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsRouterJobReceivedEventData)jsonReader.readObject(reader -> {
            AcsRouterJobReceivedEventData deserializedAcsRouterJobReceivedEventData = new AcsRouterJobReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("labels".equals(fieldName)) {
                    Map labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobReceivedEventData.setLabels(labels);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobReceivedEventData.setTags(tags);
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setJobId(reader.getString());
                    continue;
                }
                if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setChannelReference(reader.getString());
                    continue;
                }
                if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setChannelId(reader.getString());
                    continue;
                }
                if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setQueueId(reader.getString());
                    continue;
                }
                if ("unavailableForMatching".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.unavailableForMatching = reader.getBoolean();
                    continue;
                }
                if ("jobStatus".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.jobStatus = AcsRouterJobStatus.fromString(reader.getString());
                    continue;
                }
                if ("classificationPolicyId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.classificationPolicyId = reader.getString();
                    continue;
                }
                if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("requestedWorkerSelectors".equals(fieldName)) {
                    List requestedWorkerSelectors;
                    deserializedAcsRouterJobReceivedEventData.requestedWorkerSelectors = requestedWorkerSelectors = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    continue;
                }
                if ("scheduledOn".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.scheduledOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsRouterJobReceivedEventData;
        });
    }
}

