/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadEventBaseProperties;
import com.azure.messaging.eventgrid.systemevents.AcsChatThreadParticipantProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsChatParticipantAddedToThreadWithUserEventData
extends AcsChatThreadEventBaseProperties {
    private OffsetDateTime time;
    private CommunicationIdentifierModel addedByCommunicationIdentifier;
    private AcsChatThreadParticipantProperties participantAdded;

    public OffsetDateTime getTime() {
        return this.time;
    }

    public AcsChatParticipantAddedToThreadWithUserEventData setTime(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public CommunicationIdentifierModel getAddedByCommunicationIdentifier() {
        return this.addedByCommunicationIdentifier;
    }

    public AcsChatParticipantAddedToThreadWithUserEventData setAddedByCommunicationIdentifier(CommunicationIdentifierModel addedByCommunicationIdentifier) {
        this.addedByCommunicationIdentifier = addedByCommunicationIdentifier;
        return this;
    }

    public AcsChatThreadParticipantProperties getParticipantAdded() {
        return this.participantAdded;
    }

    public AcsChatParticipantAddedToThreadWithUserEventData setParticipantAdded(AcsChatThreadParticipantProperties participantAdded) {
        this.participantAdded = participantAdded;
        return this;
    }

    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setRecipientCommunicationIdentifier(CommunicationIdentifierModel recipientCommunicationIdentifier) {
        super.setRecipientCommunicationIdentifier(recipientCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatParticipantAddedToThreadWithUserEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recipientCommunicationIdentifier", (JsonSerializable)this.getRecipientCommunicationIdentifier());
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("createTime", this.getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getCreateTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeJsonField("addedByCommunicationIdentifier", (JsonSerializable)this.addedByCommunicationIdentifier);
        jsonWriter.writeJsonField("participantAdded", (JsonSerializable)this.participantAdded);
        jsonWriter.writeStringField("time", this.time == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.time));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatParticipantAddedToThreadWithUserEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatParticipantAddedToThreadWithUserEventData)jsonReader.readObject(reader -> {
            AcsChatParticipantAddedToThreadWithUserEventData deserializedAcsChatParticipantAddedToThreadWithUserEventData = new AcsChatParticipantAddedToThreadWithUserEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setRecipientCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setCreateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("addedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.addedByCommunicationIdentifier = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("participantAdded".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.participantAdded = AcsChatThreadParticipantProperties.fromJson(reader);
                    continue;
                }
                if ("time".equals(fieldName)) {
                    deserializedAcsChatParticipantAddedToThreadWithUserEventData.time = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatParticipantAddedToThreadWithUserEventData;
        });
    }
}

