/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatMessageEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AcsChatMessageDeletedInThreadEventData
extends AcsChatMessageEventInThreadBaseProperties {
    private OffsetDateTime deleteTime;

    public OffsetDateTime getDeleteTime() {
        return this.deleteTime;
    }

    public AcsChatMessageDeletedInThreadEventData setDeleteTime(OffsetDateTime deleteTime) {
        this.deleteTime = deleteTime;
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatMessageDeletedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", this.getType());
        jsonWriter.writeStringField("senderDisplayName", this.getSenderDisplayName());
        jsonWriter.writeStringField("composeTime", this.getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getComposeTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("deleteTime", this.deleteTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deleteTime));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatMessageDeletedInThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatMessageDeletedInThreadEventData)jsonReader.readObject(reader -> {
            AcsChatMessageDeletedInThreadEventData deserializedAcsChatMessageDeletedInThreadEventData = new AcsChatMessageDeletedInThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setType(reader.getString());
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setComposeTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("deleteTime".equals(fieldName)) {
                    deserializedAcsChatMessageDeletedInThreadEventData.deleteTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatMessageDeletedInThreadEventData;
        });
    }
}

