/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.messaging.eventgrid.systemevents.AcsChatMessageEventInThreadBaseProperties;
import com.azure.messaging.eventgrid.systemevents.CommunicationIdentifierModel;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public final class AcsChatAzureBotCommandReceivedInThreadEventData
extends AcsChatMessageEventInThreadBaseProperties {
    private String messageBody;
    private Map<String, String> metadata;

    public String getMessageBody() {
        return this.messageBody;
    }

    public AcsChatAzureBotCommandReceivedInThreadEventData setMessageBody(String messageBody) {
        this.messageBody = messageBody;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public AcsChatAzureBotCommandReceivedInThreadEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setMessageId(String messageId) {
        super.setMessageId(messageId);
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setSenderCommunicationIdentifier(CommunicationIdentifierModel senderCommunicationIdentifier) {
        super.setSenderCommunicationIdentifier(senderCommunicationIdentifier);
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setSenderDisplayName(String senderDisplayName) {
        super.setSenderDisplayName(senderDisplayName);
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setComposeTime(OffsetDateTime composeTime) {
        super.setComposeTime(composeTime);
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setType(String type) {
        super.setType(type);
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    @Override
    public AcsChatAzureBotCommandReceivedInThreadEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", this.getTransactionId());
        jsonWriter.writeStringField("threadId", this.getThreadId());
        jsonWriter.writeStringField("messageId", this.getMessageId());
        jsonWriter.writeJsonField("senderCommunicationIdentifier", (JsonSerializable)this.getSenderCommunicationIdentifier());
        jsonWriter.writeStringField("type", this.getType());
        jsonWriter.writeStringField("senderDisplayName", this.getSenderDisplayName());
        jsonWriter.writeStringField("composeTime", this.getComposeTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.getComposeTime()));
        jsonWriter.writeNumberField("version", (Number)this.getVersion());
        jsonWriter.writeStringField("messageBody", this.messageBody);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AcsChatAzureBotCommandReceivedInThreadEventData fromJson(JsonReader jsonReader) throws IOException {
        return (AcsChatAzureBotCommandReceivedInThreadEventData)jsonReader.readObject(reader -> {
            AcsChatAzureBotCommandReceivedInThreadEventData deserializedAcsChatAzureBotCommandReceivedInThreadEventData = new AcsChatAzureBotCommandReceivedInThreadEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setTransactionId(reader.getString());
                    continue;
                }
                if ("threadId".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setThreadId(reader.getString());
                    continue;
                }
                if ("messageId".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setMessageId(reader.getString());
                    continue;
                }
                if ("senderCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setSenderCommunicationIdentifier(CommunicationIdentifierModel.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setType(reader.getString());
                    continue;
                }
                if ("senderDisplayName".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setSenderDisplayName(reader.getString());
                    continue;
                }
                if ("composeTime".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setComposeTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.setVersion((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("messageBody".equals(fieldName)) {
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.messageBody = reader.getString();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedAcsChatAzureBotCommandReceivedInThreadEventData.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcsChatAzureBotCommandReceivedInThreadEventData;
        });
    }
}

