/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;

public final class EventGridEvent
implements JsonSerializable<EventGridEvent> {
    private String id;
    private String topic;
    private String subject;
    private Object data;
    private String eventType;
    private OffsetDateTime eventTime;
    private String metadataVersion;
    private String dataVersion;

    public String getId() {
        return this.id;
    }

    public EventGridEvent setId(String id) {
        this.id = id;
        return this;
    }

    public String getTopic() {
        return this.topic;
    }

    public EventGridEvent setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public EventGridEvent setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public Object getData() {
        return this.data;
    }

    public EventGridEvent setData(Object data) {
        this.data = data;
        return this;
    }

    public String getEventType() {
        return this.eventType;
    }

    public EventGridEvent setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public OffsetDateTime getEventTime() {
        return this.eventTime;
    }

    public EventGridEvent setEventTime(OffsetDateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public String getMetadataVersion() {
        return this.metadataVersion;
    }

    public String getDataVersion() {
        return this.dataVersion;
    }

    public EventGridEvent setDataVersion(String dataVersion) {
        this.dataVersion = dataVersion;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeUntypedField("data", this.data);
        jsonWriter.writeStringField("eventType", this.eventType);
        jsonWriter.writeStringField("eventTime", this.eventTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.eventTime));
        jsonWriter.writeStringField("dataVersion", this.dataVersion);
        jsonWriter.writeStringField("topic", this.topic);
        return jsonWriter.writeEndObject();
    }

    public static EventGridEvent fromJson(JsonReader jsonReader) throws IOException {
        return (EventGridEvent)jsonReader.readObject(reader -> {
            EventGridEvent deserializedEventGridEvent = new EventGridEvent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedEventGridEvent.id = reader.getString();
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedEventGridEvent.subject = reader.getString();
                    continue;
                }
                if ("data".equals(fieldName)) {
                    deserializedEventGridEvent.data = reader.readUntyped();
                    continue;
                }
                if ("eventType".equals(fieldName)) {
                    deserializedEventGridEvent.eventType = reader.getString();
                    continue;
                }
                if ("eventTime".equals(fieldName)) {
                    deserializedEventGridEvent.eventTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dataVersion".equals(fieldName)) {
                    deserializedEventGridEvent.dataVersion = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    deserializedEventGridEvent.topic = reader.getString();
                    continue;
                }
                if ("metadataVersion".equals(fieldName)) {
                    deserializedEventGridEvent.metadataVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventGridEvent;
        });
    }

    private static OffsetDateTime parseOffsetDateTimeBest(String datetimeString) {
        TemporalAccessor temporal = DateTimeFormatter.ISO_DATE_TIME.parseBest(datetimeString, OffsetDateTime::from, LocalDateTime::from);
        return temporal.query(TemporalQueries.offset()) == null ? LocalDateTime.from(temporal).atOffset(ZoneOffset.UTC) : OffsetDateTime.from(temporal);
    }
}

