/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.tracing.Tracer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

public final class CloudEventTracingPipelinePolicy
implements HttpPipelinePolicy {
    private final Tracer tracer;

    public CloudEventTracingPipelinePolicy(Tracer tracer) {
        this.tracer = tracer;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest request = context.getHttpRequest();
        HttpHeader contentType = request.getHeaders().get("Content-Type");
        StringBuilder bodyStringBuilder = new StringBuilder();
        if (this.tracer.isEnabled() && contentType != null && "application/cloudevents-batch+json; charset=utf-8".equals(contentType.getValue())) {
            return request.getBody().map(byteBuffer -> {
                if (byteBuffer.hasArray()) {
                    return bodyStringBuilder.append(new String(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), StandardCharsets.UTF_8));
                }
                return bodyStringBuilder.append(new String(FluxUtil.byteBufferToArray((ByteBuffer)byteBuffer.duplicate()), StandardCharsets.UTF_8));
            }).then(Mono.fromCallable(() -> CloudEventTracingPipelinePolicy.replaceTracingPlaceHolder(request, bodyStringBuilder))).then(next.process());
        }
        return next.process();
    }

    static String replaceTracingPlaceHolder(HttpRequest request, StringBuilder bodyStringBuilder) {
        int traceStatePlaceHolderIndex;
        int traceParentPlaceHolderIndex = bodyStringBuilder.indexOf(",\"traceparent\":\"TP-14b6b15b-74b6-4178-847e-d142aa2727b2\"");
        if (traceParentPlaceHolderIndex >= 0) {
            HttpHeader traceparentHeader = request.getHeaders().get("traceparent");
            bodyStringBuilder.replace(traceParentPlaceHolderIndex, ",\"traceparent\":\"TP-14b6b15b-74b6-4178-847e-d142aa2727b2\"".length() + traceParentPlaceHolderIndex, traceparentHeader != null ? String.format(",\"%s\":\"%s\"", "traceparent", traceparentHeader.getValue()) : "");
        }
        if ((traceStatePlaceHolderIndex = bodyStringBuilder.indexOf(",\"tracestate\":\"TS-14b6b15b-74b6-4178-847e-d142aa2727b2\"")) >= 0) {
            HttpHeader tracestateHeader = request.getHeaders().get("tracestate");
            bodyStringBuilder.replace(traceStatePlaceHolderIndex, ",\"tracestate\":\"TS-14b6b15b-74b6-4178-847e-d142aa2727b2\"".length() + traceStatePlaceHolderIndex, tracestateHeader != null ? String.format(",\"%s\":\"%s\"", "tracestate", tracestateHeader.getValue()) : "");
        }
        String newBodyString = bodyStringBuilder.toString();
        request.setHeader("Content-Length", String.valueOf(newBodyString.length()));
        request.setBody(newBodyString);
        return newBodyString;
    }
}

