/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid.namespaces;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.BinaryData;
import com.azure.messaging.eventgrid.namespaces.EventGridSenderClientBuilder;
import com.azure.messaging.eventgrid.namespaces.implementation.EventGridSenderClientImpl;
import java.util.List;

@ServiceClient(builder=EventGridSenderClientBuilder.class)
public final class EventGridSenderClient {
    private final EventGridSenderClientImpl serviceClient;
    private final String topicName;

    EventGridSenderClient(EventGridSenderClientImpl serviceClient, String topicName) {
        this.serviceClient = serviceClient;
        this.topicName = topicName;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> sendWithResponse(String topicName, BinaryData event, RequestOptions requestOptions) {
        return this.serviceClient.sendWithResponse(topicName, event, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> sendEventsWithResponse(String topicName, BinaryData events, RequestOptions requestOptions) {
        return this.serviceClient.sendEventsWithResponse(topicName, events, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void send(CloudEvent event) {
        RequestOptions requestOptions = new RequestOptions();
        this.sendWithResponse(this.topicName, BinaryData.fromObject((Object)event), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendWithResponse(CloudEvent event, RequestOptions requestOptions) {
        Response<BinaryData> response = this.sendWithResponse(this.topicName, BinaryData.fromObject((Object)event), requestOptions);
        return new SimpleResponse(response, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void send(List<CloudEvent> events) {
        RequestOptions requestOptions = new RequestOptions();
        this.sendEventsWithResponse(this.topicName, BinaryData.fromObject(events), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendWithResponse(List<CloudEvent> events, RequestOptions requestOptions) {
        Response<BinaryData> response = this.sendEventsWithResponse(this.topicName, BinaryData.fromObject(events), requestOptions);
        return new SimpleResponse(response, null);
    }

    public String getTopicName() {
        return this.topicName;
    }
}

