/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.iot.deviceupdate.DeviceUpdateAsyncClient;
import com.azure.iot.deviceupdate.DeviceUpdateClientBuilder;

@ServiceClient(builder=DeviceUpdateClientBuilder.class)
public final class DeviceUpdateClient {
    private final DeviceUpdateAsyncClient client;

    DeviceUpdateClient(DeviceUpdateAsyncClient client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listUpdates(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listUpdates(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginImportUpdate(BinaryData updateToImport, RequestOptions requestOptions) {
        return this.client.beginImportUpdate(updateToImport, requestOptions).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getUpdateWithResponse(String provider, String name, String version, RequestOptions requestOptions) {
        return (Response)this.client.getUpdateWithResponse(provider, name, version, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginDeleteUpdate(String provider, String name, String version, RequestOptions requestOptions) {
        return this.client.beginDeleteUpdate(provider, name, version, requestOptions).getSyncPoller();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listProviders(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listProviders(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listNames(String provider, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listNames(provider, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listVersions(String provider, String name, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listVersions(provider, name, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listFiles(String provider, String name, String version, RequestOptions requestOptions) {
        return new PagedIterable(this.client.listFiles(provider, name, version, requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileWithResponse(String provider, String name, String version, String fileId, RequestOptions requestOptions) {
        return (Response)this.client.getFileWithResponse(provider, name, version, fileId, requestOptions).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listOperationStatuses(RequestOptions requestOptions) {
        return new PagedIterable(this.client.listOperationStatuses(requestOptions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getOperationStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return (Response)this.client.getOperationStatusWithResponse(operationId, requestOptions).block();
    }
}

