/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.PollerFlux;
import com.azure.iot.deviceupdate.DeviceManagementClientBuilder;
import com.azure.iot.deviceupdate.implementation.DeviceManagementsImpl;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DeviceManagementClientBuilder.class, isAsync=true)
public final class DeviceManagementAsyncClient {
    private final DeviceManagementsImpl serviceClient;

    DeviceManagementAsyncClient(DeviceManagementsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceClasses(RequestOptions requestOptions) {
        return this.serviceClient.listDeviceClassesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceClassWithResponseAsync(deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateDeviceClassWithResponse(String deviceClassId, BinaryData deviceClassPatch, RequestOptions requestOptions) {
        return this.serviceClient.updateDeviceClassWithResponseAsync(deviceClassId, deviceClassPatch, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeviceClassWithResponse(String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.deleteDeviceClassWithResponseAsync(deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listInstallableUpdatesForDeviceClass(String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.listInstallableUpdatesForDeviceClassAsync(deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevices(RequestOptions requestOptions) {
        return this.serviceClient.listDevicesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginImportDevices(BinaryData importType, RequestOptions requestOptions) {
        return this.serviceClient.beginImportDevicesAsync(importType, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceWithResponse(String deviceId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceWithResponseAsync(deviceId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceModuleWithResponse(String deviceId, String moduleId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceModuleWithResponseAsync(deviceId, moduleId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateComplianceWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.getUpdateComplianceWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listGroups(RequestOptions requestOptions) {
        return this.serviceClient.listGroupsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.getGroupWithResponseAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.deleteGroupWithResponseAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getUpdateComplianceForGroupWithResponse(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.getUpdateComplianceForGroupWithResponseAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listBestUpdatesForGroup(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.listBestUpdatesForGroupAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentsForGroup(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.listDeploymentsForGroupAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentWithResponseAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateDeploymentWithResponse(String groupId, String deploymentId, BinaryData deployment, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateDeploymentWithResponseAsync(groupId, deploymentId, deployment, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.deleteDeploymentWithResponseAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentStatusWithResponse(String groupId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentStatusWithResponseAsync(groupId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceClassSubgroupsForGroup(String groupId, RequestOptions requestOptions) {
        return this.serviceClient.listDeviceClassSubgroupsForGroupAsync(groupId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.deleteDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassSubgroupUpdateComplianceWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceClassSubgroupUpdateComplianceWithResponseAsync(groupId, deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getBestUpdatesForDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.getBestUpdatesForDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeploymentsForDeviceClassSubgroup(String groupId, String deviceClassId, RequestOptions requestOptions) {
        return this.serviceClient.listDeploymentsForDeviceClassSubgroupAsync(groupId, deviceClassId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeploymentForDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeploymentForDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentForDeviceClassSubgroupWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.deleteDeploymentForDeviceClassSubgroupWithResponseAsync(groupId, deviceClassId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopDeploymentWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.stopDeploymentWithResponseAsync(groupId, deviceClassId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> retryDeploymentWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.retryDeploymentWithResponseAsync(groupId, deviceClassId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDeviceClassSubgroupDeploymentStatusWithResponse(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.getDeviceClassSubgroupDeploymentStatusWithResponseAsync(groupId, deviceClassId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDeviceStatesForDeviceClassSubgroupDeployment(String groupId, String deviceClassId, String deploymentId, RequestOptions requestOptions) {
        return this.serviceClient.listDeviceStatesForDeviceClassSubgroupDeploymentAsync(groupId, deviceClassId, deploymentId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getOperationStatusWithResponse(String operationId, RequestOptions requestOptions) {
        return this.serviceClient.getOperationStatusWithResponseAsync(operationId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listOperationStatuses(RequestOptions requestOptions) {
        return this.serviceClient.listOperationStatusesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> startLogCollectionWithResponse(String logCollectionId, BinaryData logCollection, RequestOptions requestOptions) {
        return this.serviceClient.startLogCollectionWithResponseAsync(logCollectionId, logCollection, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionWithResponse(String logCollectionId, RequestOptions requestOptions) {
        return this.serviceClient.getLogCollectionWithResponseAsync(logCollectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listLogCollections(RequestOptions requestOptions) {
        return this.serviceClient.listLogCollectionsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getLogCollectionDetailedStatusWithResponse(String logCollectionId, RequestOptions requestOptions) {
        return this.serviceClient.getLogCollectionDetailedStatusWithResponseAsync(logCollectionId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listHealthOfDevices(String filter, RequestOptions requestOptions) {
        return this.serviceClient.listHealthOfDevicesAsync(filter, requestOptions);
    }
}

