/*
 * Decompiled with CFR 0.152.
 */
package com.azure.iot.deviceupdate.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.iot.deviceupdate.DeviceUpdateServiceVersion;
import com.azure.iot.deviceupdate.implementation.DeviceManagementsImpl;
import com.azure.iot.deviceupdate.implementation.DeviceUpdatesImpl;

public final class DeviceUpdateClientImpl {
    private final String endpoint;
    private final String instanceId;
    private final DeviceUpdateServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final DeviceUpdatesImpl deviceUpdates;
    private final DeviceManagementsImpl deviceManagements;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public DeviceUpdateServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DeviceUpdatesImpl getDeviceUpdates() {
        return this.deviceUpdates;
    }

    public DeviceManagementsImpl getDeviceManagements() {
        return this.deviceManagements;
    }

    public DeviceUpdateClientImpl(String endpoint, String instanceId, DeviceUpdateServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, instanceId, serviceVersion);
    }

    public DeviceUpdateClientImpl(HttpPipeline httpPipeline, String endpoint, String instanceId, DeviceUpdateServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, instanceId, serviceVersion);
    }

    public DeviceUpdateClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String instanceId, DeviceUpdateServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.instanceId = instanceId;
        this.serviceVersion = serviceVersion;
        this.deviceUpdates = new DeviceUpdatesImpl(this);
        this.deviceManagements = new DeviceManagementsImpl(this);
    }
}

