/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TestRunStatistics
implements JsonSerializable<TestRunStatistics> {
    private String transaction;
    private Double sampleCount;
    private Double errorCount;
    private Double throughput;
    private Double receivedKBytesPerSec;
    private Double sentKBytesPerSec;
    private Double errorPercentage;
    private Double meanResponseTime;
    private Double medianResponseTime;
    private Double maxResponseTime;
    private Double minResponseTime;
    private Double percentile90ResponseTime;
    private Double percentile95ResponseTime;
    private Double percentile99ResponseTime;
    private Double percentile75ResponseTime;
    private Double percentile96ResponseTime;
    private Double percentile97ResponseTime;
    private Double percentile98ResponseTime;
    private Double percentile999ResponseTime;
    private Double percentile9999ResponseTime;

    private TestRunStatistics() {
    }

    public String getTransaction() {
        return this.transaction;
    }

    public Double getSampleCount() {
        return this.sampleCount;
    }

    public Double getErrorCount() {
        return this.errorCount;
    }

    public Double getThroughput() {
        return this.throughput;
    }

    public Double getReceivedKBytesPerSec() {
        return this.receivedKBytesPerSec;
    }

    public Double getSentKBytesPerSec() {
        return this.sentKBytesPerSec;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static TestRunStatistics fromJson(JsonReader jsonReader) throws IOException {
        return (TestRunStatistics)jsonReader.readObject(reader -> {
            TestRunStatistics deserializedTestRunStatistics = new TestRunStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transaction".equals(fieldName)) {
                    deserializedTestRunStatistics.transaction = reader.getString();
                    continue;
                }
                if ("sampleCount".equals(fieldName)) {
                    deserializedTestRunStatistics.sampleCount = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("errorCount".equals(fieldName)) {
                    deserializedTestRunStatistics.errorCount = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("errorPct".equals(fieldName)) {
                    deserializedTestRunStatistics.errorPercentage = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("meanResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.meanResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("medianResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.medianResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("maxResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.maxResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("minResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.minResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct1ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile90ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct2ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile95ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct3ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile99ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct75ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile75ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct96ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile96ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct97ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile97ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct98ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile98ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct999ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile999ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("pct9999ResTime".equals(fieldName)) {
                    deserializedTestRunStatistics.percentile9999ResponseTime = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("throughput".equals(fieldName)) {
                    deserializedTestRunStatistics.throughput = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("receivedKBytesPerSec".equals(fieldName)) {
                    deserializedTestRunStatistics.receivedKBytesPerSec = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("sentKBytesPerSec".equals(fieldName)) {
                    deserializedTestRunStatistics.sentKBytesPerSec = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestRunStatistics;
        });
    }

    public Double getErrorPercentage() {
        return this.errorPercentage;
    }

    public Double getMeanResponseTime() {
        return this.meanResponseTime;
    }

    public Double getMedianResponseTime() {
        return this.medianResponseTime;
    }

    public Double getMaxResponseTime() {
        return this.maxResponseTime;
    }

    public Double getMinResponseTime() {
        return this.minResponseTime;
    }

    public Double getPercentile90ResponseTime() {
        return this.percentile90ResponseTime;
    }

    public Double getPercentile95ResponseTime() {
        return this.percentile95ResponseTime;
    }

    public Double getPercentile99ResponseTime() {
        return this.percentile99ResponseTime;
    }

    public Double getPercentile75ResponseTime() {
        return this.percentile75ResponseTime;
    }

    public Double getPercentile96ResponseTime() {
        return this.percentile96ResponseTime;
    }

    public Double getPercentile97ResponseTime() {
        return this.percentile97ResponseTime;
    }

    public Double getPercentile98ResponseTime() {
        return this.percentile98ResponseTime;
    }

    public Double getPercentile999ResponseTime() {
        return this.percentile999ResponseTime;
    }

    public Double getPercentile9999ResponseTime() {
        return this.percentile9999ResponseTime;
    }
}

