/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.models.FileValidationStatus;
import com.azure.developer.loadtesting.models.LoadTestingFileType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class TestRunFileInfo
implements JsonSerializable<TestRunFileInfo> {
    private String fileName;
    private String url;
    private LoadTestingFileType fileType;
    private FileValidationStatus validationStatus;
    private String validationFailureDetails;
    private OffsetDateTime expiresOn;

    private TestRunFileInfo() {
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getUrl() {
        return this.url;
    }

    public LoadTestingFileType getFileType() {
        return this.fileType;
    }

    public FileValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public String getValidationFailureDetails() {
        return this.validationFailureDetails;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static TestRunFileInfo fromJson(JsonReader jsonReader) throws IOException {
        return (TestRunFileInfo)jsonReader.readObject(reader -> {
            TestRunFileInfo deserializedTestRunFileInfo = new TestRunFileInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileName".equals(fieldName)) {
                    deserializedTestRunFileInfo.fileName = reader.getString();
                    continue;
                }
                if ("url".equals(fieldName)) {
                    deserializedTestRunFileInfo.url = reader.getString();
                    continue;
                }
                if ("fileType".equals(fieldName)) {
                    deserializedTestRunFileInfo.fileType = LoadTestingFileType.fromString(reader.getString());
                    continue;
                }
                if ("expireDateTime".equals(fieldName)) {
                    deserializedTestRunFileInfo.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("validationStatus".equals(fieldName)) {
                    deserializedTestRunFileInfo.validationStatus = FileValidationStatus.fromString(reader.getString());
                    continue;
                }
                if ("validationFailureDetails".equals(fieldName)) {
                    deserializedTestRunFileInfo.validationFailureDetails = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestRunFileInfo;
        });
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }
}

