/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.LoadTestingAppComponent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TestRunAppComponents
implements JsonSerializable<TestRunAppComponents> {
    private Map<String, LoadTestingAppComponent> components;
    private String testRunId;
    private OffsetDateTime createdDateTime;
    private String createdBy;
    private OffsetDateTime lastModifiedDateTime;
    private String lastModifiedBy;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public Map<String, LoadTestingAppComponent> getComponents() {
        return this.components;
    }

    public TestRunAppComponents setComponents(Map<String, LoadTestingAppComponent> components) {
        this.components = components;
        this.updatedProperties.add("components");
        return this;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("components", this.components, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("components")) {
            if (this.components == null) {
                jsonWriter.writeNullField("components");
            } else {
                jsonWriter.writeMapField("components", this.components, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getLoadTestingAppComponentAccessor().prepareModelForJsonMergePatch((LoadTestingAppComponent)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getLoadTestingAppComponentAccessor().prepareModelForJsonMergePatch((LoadTestingAppComponent)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TestRunAppComponents fromJson(JsonReader jsonReader) throws IOException {
        return (TestRunAppComponents)jsonReader.readObject(reader -> {
            TestRunAppComponents deserializedTestRunAppComponents = new TestRunAppComponents();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("components".equals(fieldName)) {
                    Map components;
                    deserializedTestRunAppComponents.components = components = reader.readMap(reader1 -> LoadTestingAppComponent.fromJson(reader1));
                    continue;
                }
                if ("testRunId".equals(fieldName)) {
                    deserializedTestRunAppComponents.testRunId = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedTestRunAppComponents.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedTestRunAppComponents.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedTestRunAppComponents.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedTestRunAppComponents.lastModifiedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestRunAppComponents;
        });
    }

    static {
        JsonMergePatchHelper.setTestRunAppComponentsAccessor(new JsonMergePatchHelper.TestRunAppComponentsAccessor(){

            @Override
            public TestRunAppComponents prepareModelForJsonMergePatch(TestRunAppComponents model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TestRunAppComponents model) {
                return model.jsonMergePatch;
            }
        });
    }
}

