/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.ErrorDetails;
import com.azure.developer.loadtesting.models.TargetResourceConfigurations;
import com.azure.developer.loadtesting.models.TestProfileRunRecommendation;
import com.azure.developer.loadtesting.models.TestProfileRunStatus;
import com.azure.developer.loadtesting.models.TestRunDetail;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TestProfileRun
implements JsonSerializable<TestProfileRun> {
    private String testProfileRunId;
    private String displayName;
    private String description;
    private String testProfileId;
    private String targetResourceId;
    private TargetResourceConfigurations targetResourceConfigurations;
    private TestProfileRunStatus status;
    private List<ErrorDetails> errorDetails;
    private OffsetDateTime startDateTime;
    private OffsetDateTime endDateTime;
    private Long durationInSeconds;
    private Map<String, TestRunDetail> testRunDetails;
    private List<TestProfileRunRecommendation> recommendations;
    private OffsetDateTime createdDateTime;
    private String createdBy;
    private OffsetDateTime lastModifiedDateTime;
    private String lastModifiedBy;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getTestProfileRunId() {
        return this.testProfileRunId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public TestProfileRun setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updatedProperties.add("displayName");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public TestProfileRun setDescription(String description) {
        this.description = description;
        this.updatedProperties.add("description");
        return this;
    }

    public String getTestProfileId() {
        return this.testProfileId;
    }

    public TestProfileRun setTestProfileId(String testProfileId) {
        this.testProfileId = testProfileId;
        this.updatedProperties.add("testProfileId");
        return this;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public TargetResourceConfigurations getTargetResourceConfigurations() {
        return this.targetResourceConfigurations;
    }

    public TestProfileRunStatus getStatus() {
        return this.status;
    }

    public List<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public Long getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public Map<String, TestRunDetail> getTestRunDetails() {
        return this.testRunDetails;
    }

    public List<TestProfileRunRecommendation> getRecommendations() {
        return this.recommendations;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("testProfileId", this.testProfileId);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("displayName")) {
            if (this.displayName == null) {
                jsonWriter.writeNullField("displayName");
            } else {
                jsonWriter.writeStringField("displayName", this.displayName);
            }
        }
        if (this.updatedProperties.contains("description")) {
            if (this.description == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.description);
            }
        }
        if (this.updatedProperties.contains("testProfileId")) {
            if (this.testProfileId == null) {
                jsonWriter.writeNullField("testProfileId");
            } else {
                jsonWriter.writeStringField("testProfileId", this.testProfileId);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TestProfileRun fromJson(JsonReader jsonReader) throws IOException {
        return (TestProfileRun)jsonReader.readObject(reader -> {
            TestProfileRun deserializedTestProfileRun = new TestProfileRun();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("testProfileRunId".equals(fieldName)) {
                    deserializedTestProfileRun.testProfileRunId = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedTestProfileRun.displayName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTestProfileRun.description = reader.getString();
                    continue;
                }
                if ("testProfileId".equals(fieldName)) {
                    deserializedTestProfileRun.testProfileId = reader.getString();
                    continue;
                }
                if ("targetResourceId".equals(fieldName)) {
                    deserializedTestProfileRun.targetResourceId = reader.getString();
                    continue;
                }
                if ("targetResourceConfigurations".equals(fieldName)) {
                    deserializedTestProfileRun.targetResourceConfigurations = TargetResourceConfigurations.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTestProfileRun.status = TestProfileRunStatus.fromString(reader.getString());
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    List errorDetails;
                    deserializedTestProfileRun.errorDetails = errorDetails = reader.readArray(reader1 -> ErrorDetails.fromJson(reader1));
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedTestProfileRun.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedTestProfileRun.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("durationInSeconds".equals(fieldName)) {
                    deserializedTestProfileRun.durationInSeconds = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("testRunDetails".equals(fieldName)) {
                    Map testRunDetails;
                    deserializedTestProfileRun.testRunDetails = testRunDetails = reader.readMap(reader1 -> TestRunDetail.fromJson(reader1));
                    continue;
                }
                if ("recommendations".equals(fieldName)) {
                    List recommendations;
                    deserializedTestProfileRun.recommendations = recommendations = reader.readArray(reader1 -> TestProfileRunRecommendation.fromJson(reader1));
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedTestProfileRun.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedTestProfileRun.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedTestProfileRun.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedTestProfileRun.lastModifiedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestProfileRun;
        });
    }

    static {
        JsonMergePatchHelper.setTestProfileRunAccessor(new JsonMergePatchHelper.TestProfileRunAccessor(){

            @Override
            public TestProfileRun prepareModelForJsonMergePatch(TestProfileRun model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TestProfileRun model) {
                return model.jsonMergePatch;
            }
        });
    }
}

