/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.LoadTestingAppComponent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TestAppComponents
implements JsonSerializable<TestAppComponents> {
    private Map<String, LoadTestingAppComponent> components;
    private String testId;
    private OffsetDateTime createdDateTime;
    private String createdBy;
    private OffsetDateTime lastModifiedDateTime;
    private String lastModifiedBy;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public Map<String, LoadTestingAppComponent> getComponents() {
        return this.components;
    }

    public TestAppComponents setComponents(Map<String, LoadTestingAppComponent> components) {
        this.components = components;
        this.updatedProperties.add("components");
        return this;
    }

    public String getTestId() {
        return this.testId;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("components", this.components, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("components")) {
            if (this.components == null) {
                jsonWriter.writeNullField("components");
            } else {
                jsonWriter.writeMapField("components", this.components, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getLoadTestingAppComponentAccessor().prepareModelForJsonMergePatch((LoadTestingAppComponent)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getLoadTestingAppComponentAccessor().prepareModelForJsonMergePatch((LoadTestingAppComponent)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TestAppComponents fromJson(JsonReader jsonReader) throws IOException {
        return (TestAppComponents)jsonReader.readObject(reader -> {
            TestAppComponents deserializedTestAppComponents = new TestAppComponents();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("components".equals(fieldName)) {
                    Map components;
                    deserializedTestAppComponents.components = components = reader.readMap(reader1 -> LoadTestingAppComponent.fromJson(reader1));
                    continue;
                }
                if ("testId".equals(fieldName)) {
                    deserializedTestAppComponents.testId = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedTestAppComponents.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedTestAppComponents.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedTestAppComponents.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedTestAppComponents.lastModifiedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestAppComponents;
        });
    }

    static {
        JsonMergePatchHelper.setTestAppComponentsAccessor(new JsonMergePatchHelper.TestAppComponentsAccessor(){

            @Override
            public TestAppComponents prepareModelForJsonMergePatch(TestAppComponents model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TestAppComponents model) {
                return model.jsonMergePatch;
            }
        });
    }
}

