/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.PassFailMetric;
import com.azure.developer.loadtesting.models.PassFailServerMetric;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class PassFailCriteria
implements JsonSerializable<PassFailCriteria> {
    private Map<String, PassFailMetric> passFailMetrics;
    private Map<String, PassFailServerMetric> passFailServerMetrics;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public Map<String, PassFailMetric> getPassFailMetrics() {
        return this.passFailMetrics;
    }

    public PassFailCriteria setPassFailMetrics(Map<String, PassFailMetric> passFailMetrics) {
        this.passFailMetrics = passFailMetrics;
        this.updatedProperties.add("passFailMetrics");
        return this;
    }

    public Map<String, PassFailServerMetric> getPassFailServerMetrics() {
        return this.passFailServerMetrics;
    }

    public PassFailCriteria setPassFailServerMetrics(Map<String, PassFailServerMetric> passFailServerMetrics) {
        this.passFailServerMetrics = passFailServerMetrics;
        this.updatedProperties.add("passFailServerMetrics");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("passFailMetrics", this.passFailMetrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("passFailServerMetrics", this.passFailServerMetrics, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("passFailMetrics")) {
            if (this.passFailMetrics == null) {
                jsonWriter.writeNullField("passFailMetrics");
            } else {
                jsonWriter.writeMapField("passFailMetrics", this.passFailMetrics, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getPassFailMetricAccessor().prepareModelForJsonMergePatch((PassFailMetric)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getPassFailMetricAccessor().prepareModelForJsonMergePatch((PassFailMetric)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        if (this.updatedProperties.contains("passFailServerMetrics")) {
            if (this.passFailServerMetrics == null) {
                jsonWriter.writeNullField("passFailServerMetrics");
            } else {
                jsonWriter.writeMapField("passFailServerMetrics", this.passFailServerMetrics, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getPassFailServerMetricAccessor().prepareModelForJsonMergePatch((PassFailServerMetric)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getPassFailServerMetricAccessor().prepareModelForJsonMergePatch((PassFailServerMetric)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PassFailCriteria fromJson(JsonReader jsonReader) throws IOException {
        return (PassFailCriteria)jsonReader.readObject(reader -> {
            PassFailCriteria deserializedPassFailCriteria = new PassFailCriteria();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("passFailMetrics".equals(fieldName)) {
                    Map passFailMetrics;
                    deserializedPassFailCriteria.passFailMetrics = passFailMetrics = reader.readMap(reader1 -> PassFailMetric.fromJson(reader1));
                    continue;
                }
                if ("passFailServerMetrics".equals(fieldName)) {
                    Map passFailServerMetrics;
                    deserializedPassFailCriteria.passFailServerMetrics = passFailServerMetrics = reader.readMap(reader1 -> PassFailServerMetric.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPassFailCriteria;
        });
    }

    static {
        JsonMergePatchHelper.setPassFailCriteriaAccessor(new JsonMergePatchHelper.PassFailCriteriaAccessor(){

            @Override
            public PassFailCriteria prepareModelForJsonMergePatch(PassFailCriteria model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(PassFailCriteria model) {
                return model.jsonMergePatch;
            }
        });
    }
}

