/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class MetricValue
implements JsonSerializable<MetricValue> {
    private OffsetDateTime timestamp;
    private Double value;

    private MetricValue() {
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public Double getValue() {
        return this.value;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeNumberField("value", (Number)this.value);
        return jsonWriter.writeEndObject();
    }

    public static MetricValue fromJson(JsonReader jsonReader) throws IOException {
        return (MetricValue)jsonReader.readObject(reader -> {
            MetricValue deserializedMetricValue = new MetricValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedMetricValue.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedMetricValue.value = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricValue;
        });
    }
}

