/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.models.AggregationType;
import com.azure.developer.loadtesting.models.MetricAvailability;
import com.azure.developer.loadtesting.models.MetricUnit;
import com.azure.developer.loadtesting.models.NameAndDescription;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MetricDefinition
implements JsonSerializable<MetricDefinition> {
    private List<NameAndDescription> dimensions;
    private String description;
    private String name;
    private String namespace;
    private AggregationType primaryAggregationType;
    private List<String> supportedAggregationTypes;
    private MetricUnit unit;
    private List<MetricAvailability> metricAvailabilities;

    private MetricDefinition() {
    }

    public List<NameAndDescription> getDimensions() {
        return this.dimensions;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AggregationType getPrimaryAggregationType() {
        return this.primaryAggregationType;
    }

    public List<String> getSupportedAggregationTypes() {
        return this.supportedAggregationTypes;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    public List<MetricAvailability> getMetricAvailabilities() {
        return this.metricAvailabilities;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("primaryAggregationType", this.primaryAggregationType == null ? null : this.primaryAggregationType.toString());
        jsonWriter.writeArrayField("supportedAggregationTypes", this.supportedAggregationTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("metricAvailabilities", this.metricAvailabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (MetricDefinition)jsonReader.readObject(reader -> {
            MetricDefinition deserializedMetricDefinition = new MetricDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedMetricDefinition.dimensions = dimensions = reader.readArray(reader1 -> NameAndDescription.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMetricDefinition.description = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetricDefinition.name = reader.getString();
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedMetricDefinition.namespace = reader.getString();
                    continue;
                }
                if ("primaryAggregationType".equals(fieldName)) {
                    deserializedMetricDefinition.primaryAggregationType = AggregationType.fromString(reader.getString());
                    continue;
                }
                if ("supportedAggregationTypes".equals(fieldName)) {
                    List supportedAggregationTypes;
                    deserializedMetricDefinition.supportedAggregationTypes = supportedAggregationTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricDefinition.unit = MetricUnit.fromString(reader.getString());
                    continue;
                }
                if ("metricAvailabilities".equals(fieldName)) {
                    List metricAvailabilities;
                    deserializedMetricDefinition.metricAvailabilities = metricAvailabilities = reader.readArray(reader1 -> MetricAvailability.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricDefinition;
        });
    }
}

