/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.AutoStopCriteria;
import com.azure.developer.loadtesting.models.CreatedByType;
import com.azure.developer.loadtesting.models.ErrorDetails;
import com.azure.developer.loadtesting.models.LoadTestConfiguration;
import com.azure.developer.loadtesting.models.LoadTestKind;
import com.azure.developer.loadtesting.models.PassFailCriteria;
import com.azure.developer.loadtesting.models.PassFailTestResult;
import com.azure.developer.loadtesting.models.RequestDataLevel;
import com.azure.developer.loadtesting.models.TestCertificate;
import com.azure.developer.loadtesting.models.TestRunArtifacts;
import com.azure.developer.loadtesting.models.TestRunStatistics;
import com.azure.developer.loadtesting.models.TestRunStatus;
import com.azure.developer.loadtesting.models.TestSecret;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class LoadTestRun
implements JsonSerializable<LoadTestRun> {
    private String testRunId;
    private PassFailCriteria passFailCriteria;
    private AutoStopCriteria autoStopCriteria;
    private Map<String, TestSecret> secrets;
    private TestCertificate certificate;
    private Map<String, String> environmentVariables;
    private List<ErrorDetails> errorDetails;
    private Map<String, TestRunStatistics> testRunStatistics;
    private Map<String, TestRunStatistics> regionalStatistics;
    private LoadTestConfiguration loadTestConfiguration;
    private TestRunArtifacts testArtifacts;
    private PassFailTestResult testResult;
    private Integer virtualUsers;
    private String displayName;
    private String testId;
    private String description;
    private TestRunStatus status;
    private OffsetDateTime startDateTime;
    private OffsetDateTime endDateTime;
    private OffsetDateTime executedDateTime;
    private String portalUrl;
    private Long duration;
    private Double virtualUserHours;
    private String subnetId;
    private LoadTestKind kind;
    private RequestDataLevel requestDataLevel;
    private Boolean debugLogsEnabled;
    private Boolean publicIpDisabled;
    private CreatedByType createdByType;
    private OffsetDateTime createdDateTime;
    private String createdBy;
    private OffsetDateTime lastModifiedDateTime;
    private String lastModifiedBy;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getTestRunId() {
        return this.testRunId;
    }

    public PassFailCriteria getPassFailCriteria() {
        return this.passFailCriteria;
    }

    public LoadTestRun setPassFailCriteria(PassFailCriteria passFailCriteria) {
        this.passFailCriteria = passFailCriteria;
        this.updatedProperties.add("passFailCriteria");
        return this;
    }

    public AutoStopCriteria getAutoStopCriteria() {
        return this.autoStopCriteria;
    }

    public LoadTestRun setAutoStopCriteria(AutoStopCriteria autoStopCriteria) {
        this.autoStopCriteria = autoStopCriteria;
        this.updatedProperties.add("autoStopCriteria");
        return this;
    }

    public Map<String, TestSecret> getSecrets() {
        return this.secrets;
    }

    public LoadTestRun setSecrets(Map<String, TestSecret> secrets) {
        this.secrets = secrets;
        this.updatedProperties.add("secrets");
        return this;
    }

    public TestCertificate getCertificate() {
        return this.certificate;
    }

    public LoadTestRun setCertificate(TestCertificate certificate) {
        this.certificate = certificate;
        this.updatedProperties.add("certificate");
        return this;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public LoadTestRun setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.updatedProperties.add("environmentVariables");
        return this;
    }

    public List<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public Map<String, TestRunStatistics> getTestRunStatistics() {
        return this.testRunStatistics;
    }

    public Map<String, TestRunStatistics> getRegionalStatistics() {
        return this.regionalStatistics;
    }

    public LoadTestConfiguration getLoadTestConfiguration() {
        return this.loadTestConfiguration;
    }

    public TestRunArtifacts getTestArtifacts() {
        return this.testArtifacts;
    }

    public PassFailTestResult getTestResult() {
        return this.testResult;
    }

    public Integer getVirtualUsers() {
        return this.virtualUsers;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LoadTestRun setDisplayName(String displayName) {
        this.displayName = displayName;
        this.updatedProperties.add("displayName");
        return this;
    }

    public String getTestId() {
        return this.testId;
    }

    public LoadTestRun setTestId(String testId) {
        this.testId = testId;
        this.updatedProperties.add("testId");
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public LoadTestRun setDescription(String description) {
        this.description = description;
        this.updatedProperties.add("description");
        return this;
    }

    public TestRunStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public OffsetDateTime getEndDateTime() {
        return this.endDateTime;
    }

    public OffsetDateTime getExecutedDateTime() {
        return this.executedDateTime;
    }

    public String getPortalUrl() {
        return this.portalUrl;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Double getVirtualUserHours() {
        return this.virtualUserHours;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public LoadTestKind getKind() {
        return this.kind;
    }

    public RequestDataLevel getRequestDataLevel() {
        return this.requestDataLevel;
    }

    public LoadTestRun setRequestDataLevel(RequestDataLevel requestDataLevel) {
        this.requestDataLevel = requestDataLevel;
        this.updatedProperties.add("requestDataLevel");
        return this;
    }

    public Boolean isDebugLogsEnabled() {
        return this.debugLogsEnabled;
    }

    public LoadTestRun setDebugLogsEnabled(Boolean debugLogsEnabled) {
        this.debugLogsEnabled = debugLogsEnabled;
        this.updatedProperties.add("debugLogsEnabled");
        return this;
    }

    public Boolean isPublicIpDisabled() {
        return this.publicIpDisabled;
    }

    public CreatedByType getCreatedByType() {
        return this.createdByType;
    }

    public LoadTestRun setCreatedByType(CreatedByType createdByType) {
        this.createdByType = createdByType;
        this.updatedProperties.add("createdByType");
        return this;
    }

    public OffsetDateTime getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("passFailCriteria", (JsonSerializable)this.passFailCriteria);
        jsonWriter.writeJsonField("autoStopCriteria", (JsonSerializable)this.autoStopCriteria);
        jsonWriter.writeMapField("secrets", this.secrets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("certificate", (JsonSerializable)this.certificate);
        jsonWriter.writeMapField("environmentVariables", this.environmentVariables, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("testId", this.testId);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("requestDataLevel", this.requestDataLevel == null ? null : this.requestDataLevel.toString());
        jsonWriter.writeBooleanField("debugLogsEnabled", this.debugLogsEnabled);
        jsonWriter.writeStringField("createdByType", this.createdByType == null ? null : this.createdByType.toString());
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("passFailCriteria")) {
            if (this.passFailCriteria == null) {
                jsonWriter.writeNullField("passFailCriteria");
            } else {
                JsonMergePatchHelper.getPassFailCriteriaAccessor().prepareModelForJsonMergePatch(this.passFailCriteria, true);
                jsonWriter.writeJsonField("passFailCriteria", (JsonSerializable)this.passFailCriteria);
                JsonMergePatchHelper.getPassFailCriteriaAccessor().prepareModelForJsonMergePatch(this.passFailCriteria, false);
            }
        }
        if (this.updatedProperties.contains("autoStopCriteria")) {
            if (this.autoStopCriteria == null) {
                jsonWriter.writeNullField("autoStopCriteria");
            } else {
                JsonMergePatchHelper.getAutoStopCriteriaAccessor().prepareModelForJsonMergePatch(this.autoStopCriteria, true);
                jsonWriter.writeJsonField("autoStopCriteria", (JsonSerializable)this.autoStopCriteria);
                JsonMergePatchHelper.getAutoStopCriteriaAccessor().prepareModelForJsonMergePatch(this.autoStopCriteria, false);
            }
        }
        if (this.updatedProperties.contains("secrets")) {
            if (this.secrets == null) {
                jsonWriter.writeNullField("secrets");
            } else {
                jsonWriter.writeMapField("secrets", this.secrets, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getTestSecretAccessor().prepareModelForJsonMergePatch((TestSecret)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getTestSecretAccessor().prepareModelForJsonMergePatch((TestSecret)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        if (this.updatedProperties.contains("certificate")) {
            if (this.certificate == null) {
                jsonWriter.writeNullField("certificate");
            } else {
                JsonMergePatchHelper.getTestCertificateAccessor().prepareModelForJsonMergePatch(this.certificate, true);
                jsonWriter.writeJsonField("certificate", (JsonSerializable)this.certificate);
                JsonMergePatchHelper.getTestCertificateAccessor().prepareModelForJsonMergePatch(this.certificate, false);
            }
        }
        if (this.updatedProperties.contains("environmentVariables")) {
            if (this.environmentVariables == null) {
                jsonWriter.writeNullField("environmentVariables");
            } else {
                jsonWriter.writeMapField("environmentVariables", this.environmentVariables, (writer, element) -> {
                    if (element != null) {
                        writer.writeString(element);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        if (this.updatedProperties.contains("displayName")) {
            if (this.displayName == null) {
                jsonWriter.writeNullField("displayName");
            } else {
                jsonWriter.writeStringField("displayName", this.displayName);
            }
        }
        if (this.updatedProperties.contains("testId")) {
            if (this.testId == null) {
                jsonWriter.writeNullField("testId");
            } else {
                jsonWriter.writeStringField("testId", this.testId);
            }
        }
        if (this.updatedProperties.contains("description")) {
            if (this.description == null) {
                jsonWriter.writeNullField("description");
            } else {
                jsonWriter.writeStringField("description", this.description);
            }
        }
        if (this.updatedProperties.contains("requestDataLevel")) {
            if (this.requestDataLevel == null) {
                jsonWriter.writeNullField("requestDataLevel");
            } else {
                jsonWriter.writeStringField("requestDataLevel", this.requestDataLevel.toString());
            }
        }
        if (this.updatedProperties.contains("debugLogsEnabled")) {
            if (this.debugLogsEnabled == null) {
                jsonWriter.writeNullField("debugLogsEnabled");
            } else {
                jsonWriter.writeBooleanField("debugLogsEnabled", this.debugLogsEnabled);
            }
        }
        if (this.updatedProperties.contains("createdByType")) {
            if (this.createdByType == null) {
                jsonWriter.writeNullField("createdByType");
            } else {
                jsonWriter.writeStringField("createdByType", this.createdByType.toString());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LoadTestRun fromJson(JsonReader jsonReader) throws IOException {
        return (LoadTestRun)jsonReader.readObject(reader -> {
            LoadTestRun deserializedLoadTestRun = new LoadTestRun();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("testRunId".equals(fieldName)) {
                    deserializedLoadTestRun.testRunId = reader.getString();
                    continue;
                }
                if ("passFailCriteria".equals(fieldName)) {
                    deserializedLoadTestRun.passFailCriteria = PassFailCriteria.fromJson(reader);
                    continue;
                }
                if ("autoStopCriteria".equals(fieldName)) {
                    deserializedLoadTestRun.autoStopCriteria = AutoStopCriteria.fromJson(reader);
                    continue;
                }
                if ("secrets".equals(fieldName)) {
                    Map secrets;
                    deserializedLoadTestRun.secrets = secrets = reader.readMap(reader1 -> TestSecret.fromJson(reader1));
                    continue;
                }
                if ("certificate".equals(fieldName)) {
                    deserializedLoadTestRun.certificate = TestCertificate.fromJson(reader);
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    Map environmentVariables;
                    deserializedLoadTestRun.environmentVariables = environmentVariables = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("errorDetails".equals(fieldName)) {
                    List errorDetails;
                    deserializedLoadTestRun.errorDetails = errorDetails = reader.readArray(reader1 -> ErrorDetails.fromJson(reader1));
                    continue;
                }
                if ("testRunStatistics".equals(fieldName)) {
                    Map testRunStatistics;
                    deserializedLoadTestRun.testRunStatistics = testRunStatistics = reader.readMap(reader1 -> TestRunStatistics.fromJson(reader1));
                    continue;
                }
                if ("regionalStatistics".equals(fieldName)) {
                    Map regionalStatistics;
                    deserializedLoadTestRun.regionalStatistics = regionalStatistics = reader.readMap(reader1 -> TestRunStatistics.fromJson(reader1));
                    continue;
                }
                if ("loadTestConfiguration".equals(fieldName)) {
                    deserializedLoadTestRun.loadTestConfiguration = LoadTestConfiguration.fromJson(reader);
                    continue;
                }
                if ("testArtifacts".equals(fieldName)) {
                    deserializedLoadTestRun.testArtifacts = TestRunArtifacts.fromJson(reader);
                    continue;
                }
                if ("testResult".equals(fieldName)) {
                    deserializedLoadTestRun.testResult = PassFailTestResult.fromString(reader.getString());
                    continue;
                }
                if ("virtualUsers".equals(fieldName)) {
                    deserializedLoadTestRun.virtualUsers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedLoadTestRun.displayName = reader.getString();
                    continue;
                }
                if ("testId".equals(fieldName)) {
                    deserializedLoadTestRun.testId = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedLoadTestRun.description = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedLoadTestRun.status = TestRunStatus.fromString(reader.getString());
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedLoadTestRun.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedLoadTestRun.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("executedDateTime".equals(fieldName)) {
                    deserializedLoadTestRun.executedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("portalUrl".equals(fieldName)) {
                    deserializedLoadTestRun.portalUrl = reader.getString();
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedLoadTestRun.duration = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("virtualUserHours".equals(fieldName)) {
                    deserializedLoadTestRun.virtualUserHours = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("subnetId".equals(fieldName)) {
                    deserializedLoadTestRun.subnetId = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedLoadTestRun.kind = LoadTestKind.fromString(reader.getString());
                    continue;
                }
                if ("requestDataLevel".equals(fieldName)) {
                    deserializedLoadTestRun.requestDataLevel = RequestDataLevel.fromString(reader.getString());
                    continue;
                }
                if ("debugLogsEnabled".equals(fieldName)) {
                    deserializedLoadTestRun.debugLogsEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("publicIPDisabled".equals(fieldName)) {
                    deserializedLoadTestRun.publicIpDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("createdByType".equals(fieldName)) {
                    deserializedLoadTestRun.createdByType = CreatedByType.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedLoadTestRun.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedLoadTestRun.createdBy = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedLoadTestRun.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedLoadTestRun.lastModifiedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadTestRun;
        });
    }

    static {
        JsonMergePatchHelper.setLoadTestRunAccessor(new JsonMergePatchHelper.LoadTestRunAccessor(){

            @Override
            public LoadTestRun prepareModelForJsonMergePatch(LoadTestRun model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(LoadTestRun model) {
                return model.jsonMergePatch;
            }
        });
    }
}

