/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.FunctionFlexConsumptionResourceConfiguration;
import com.azure.developer.loadtesting.models.ResourceKind;
import com.azure.developer.loadtesting.models.TargetResourceConfigurations;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class FunctionFlexConsumptionTargetResourceConfigurations
extends TargetResourceConfigurations {
    private ResourceKind kind = ResourceKind.FUNCTIONS_FLEX_CONSUMPTION;
    private Map<String, FunctionFlexConsumptionResourceConfiguration> configurations;
    private final Set<String> updatedProperties = new HashSet<String>();

    @Override
    public ResourceKind getKind() {
        return this.kind;
    }

    public Map<String, FunctionFlexConsumptionResourceConfiguration> getConfigurations() {
        return this.configurations;
    }

    public FunctionFlexConsumptionTargetResourceConfigurations setConfigurations(Map<String, FunctionFlexConsumptionResourceConfiguration> configurations) {
        this.configurations = configurations;
        this.updatedProperties.add("configurations");
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (JsonMergePatchHelper.getTargetResourceConfigurationsAccessor().isJsonMergePatch(this)) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeMapField("configurations", this.configurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind.toString());
        if (this.updatedProperties.contains("configurations")) {
            if (this.configurations == null) {
                jsonWriter.writeNullField("configurations");
            } else {
                jsonWriter.writeMapField("configurations", this.configurations, (writer, element) -> {
                    if (element != null) {
                        JsonMergePatchHelper.getFunctionFlexConsumptionResourceConfigurationAccessor().prepareModelForJsonMergePatch((FunctionFlexConsumptionResourceConfiguration)element, true);
                        writer.writeJson((JsonSerializable)element);
                        JsonMergePatchHelper.getFunctionFlexConsumptionResourceConfigurationAccessor().prepareModelForJsonMergePatch((FunctionFlexConsumptionResourceConfiguration)element, false);
                    } else {
                        writer.writeNull();
                    }
                });
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static FunctionFlexConsumptionTargetResourceConfigurations fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionFlexConsumptionTargetResourceConfigurations)jsonReader.readObject(reader -> {
            FunctionFlexConsumptionTargetResourceConfigurations deserializedFunctionFlexConsumptionTargetResourceConfigurations = new FunctionFlexConsumptionTargetResourceConfigurations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedFunctionFlexConsumptionTargetResourceConfigurations.kind = ResourceKind.fromString(reader.getString());
                    continue;
                }
                if ("configurations".equals(fieldName)) {
                    Map configurations;
                    deserializedFunctionFlexConsumptionTargetResourceConfigurations.configurations = configurations = reader.readMap(reader1 -> FunctionFlexConsumptionResourceConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFunctionFlexConsumptionTargetResourceConfigurations;
        });
    }
}

