/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

public final class AutoStopCriteria
implements JsonSerializable<AutoStopCriteria> {
    private Boolean autoStopDisabled;
    private Double errorRate;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;
    private Long errorRateTimeWindow;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public Boolean isAutoStopDisabled() {
        return this.autoStopDisabled;
    }

    public AutoStopCriteria setAutoStopDisabled(Boolean autoStopDisabled) {
        this.autoStopDisabled = autoStopDisabled;
        this.updatedProperties.add("autoStopDisabled");
        return this;
    }

    public Double getErrorRate() {
        return this.errorRate;
    }

    public AutoStopCriteria setErrorRate(Double errorRate) {
        this.errorRate = errorRate;
        this.updatedProperties.add("errorRate");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("autoStopDisabled", this.autoStopDisabled);
        jsonWriter.writeNumberField("errorRate", (Number)this.errorRate);
        jsonWriter.writeNumberField("errorRateTimeWindowInSeconds", (Number)this.errorRateTimeWindow);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("autoStopDisabled")) {
            if (this.autoStopDisabled == null) {
                jsonWriter.writeNullField("autoStopDisabled");
            } else {
                jsonWriter.writeBooleanField("autoStopDisabled", this.autoStopDisabled);
            }
        }
        if (this.updatedProperties.contains("errorRate")) {
            if (this.errorRate == null) {
                jsonWriter.writeNullField("errorRate");
            } else {
                jsonWriter.writeNumberField("errorRate", (Number)this.errorRate);
            }
        }
        if (this.updatedProperties.contains("errorRateTimeWindow")) {
            if (this.errorRateTimeWindow == null) {
                jsonWriter.writeNullField("errorRateTimeWindowInSeconds");
            } else {
                jsonWriter.writeNumberField("errorRateTimeWindowInSeconds", (Number)this.errorRateTimeWindow);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AutoStopCriteria fromJson(JsonReader jsonReader) throws IOException {
        return (AutoStopCriteria)jsonReader.readObject(reader -> {
            AutoStopCriteria deserializedAutoStopCriteria = new AutoStopCriteria();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("autoStopDisabled".equals(fieldName)) {
                    deserializedAutoStopCriteria.autoStopDisabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("errorRate".equals(fieldName)) {
                    deserializedAutoStopCriteria.errorRate = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("errorRateTimeWindowInSeconds".equals(fieldName)) {
                    deserializedAutoStopCriteria.errorRateTimeWindow = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoStopCriteria;
        });
    }

    public Duration getErrorRateTimeWindow() {
        if (this.errorRateTimeWindow == null) {
            return null;
        }
        return Duration.ofSeconds(this.errorRateTimeWindow);
    }

    public AutoStopCriteria setErrorRateTimeWindow(Duration errorRateTimeWindow) {
        this.errorRateTimeWindow = errorRateTimeWindow == null ? null : Long.valueOf(errorRateTimeWindow.getSeconds());
        this.updatedProperties.add("errorRateTimeWindow");
        return this;
    }

    static {
        JsonMergePatchHelper.setAutoStopCriteriaAccessor(new JsonMergePatchHelper.AutoStopCriteriaAccessor(){

            @Override
            public AutoStopCriteria prepareModelForJsonMergePatch(AutoStopCriteria model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(AutoStopCriteria model) {
                return model.jsonMergePatch;
            }
        });
    }
}

