/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.loadtesting.LoadTestRunClientBuilder;
import com.azure.developer.loadtesting.PollingUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.implementation.LoadTestRunClientImpl;
import com.azure.developer.loadtesting.models.LoadTestRun;
import com.azure.developer.loadtesting.models.MetricDefinitions;
import com.azure.developer.loadtesting.models.MetricNamespaces;
import com.azure.developer.loadtesting.models.TestProfileRun;
import com.azure.developer.loadtesting.models.TestRunAppComponents;
import com.azure.developer.loadtesting.models.TestRunFileInfo;
import com.azure.developer.loadtesting.models.TestRunServerMetricsConfiguration;
import com.azure.developer.loadtesting.models.TimeGrain;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=LoadTestRunClientBuilder.class)
public final class LoadTestRunClient {
    private final LoadTestRunClientImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateServerMetricsConfigWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponse(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginTestRun(String testRunId, BinaryData body, RequestOptions testRunRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (testRunRequestOptions != null) {
            defaultRequestOptions.setContext(testRunRequestOptions.getContext());
        }
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(5L), context -> PollingUtils.getTestRunStatus((BinaryData)this.createOrUpdateTestRunWithResponse(testRunId, body, testRunRequestOptions).getValue()), context -> PollingUtils.getTestRunStatus((BinaryData)this.getTestRunWithResponse(testRunId, defaultRequestOptions).getValue()), (activationResponse, context) -> (BinaryData)this.stopTestRunWithResponse(testRunId, defaultRequestOptions).getValue(), context -> (BinaryData)this.getTestRunWithResponse(testRunId, defaultRequestOptions).getValue());
    }

    public SyncPoller<LoadTestRun, LoadTestRun> beginTestRun(String testRunId, LoadTestRun testRun, String oldTestRunId) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(5L), context -> PollingUtils.getTestRunStatus(this.createOrUpdateTestRun(testRunId, testRun, oldTestRunId)), context -> PollingUtils.getTestRunStatus(this.getTestRun(testRunId)), (activationResponse, context) -> this.stopTestRun(testRunId), context -> this.getTestRun(testRunId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateAppComponentsWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponse(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetrics(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        return this.serviceClient.listMetrics(testRunId, metricName, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAppComponentsWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getServerMetricsConfigWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> createOrUpdateTestRunWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestRunWithResponse(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestRunWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunFileWithResponse(String testRunId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunFileWithResponse(testRunId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestRuns(RequestOptions requestOptions) {
        return this.serviceClient.listTestRuns(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.stopTestRunWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricNamespacesWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getMetricNamespacesWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricDefinitionsWithResponse(String testRunId, String metricNamespace, RequestOptions requestOptions) {
        return this.serviceClient.getMetricDefinitionsWithResponse(testRunId, metricNamespace, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> createOrUpdateTestProfileRunWithResponse(String testProfileRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestProfileRunWithResponse(testProfileRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestProfileRunWithResponse(String testProfileRunId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestProfileRunWithResponse(testProfileRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestProfileRunWithResponse(String testProfileRunId, RequestOptions requestOptions) {
        return this.serviceClient.getTestProfileRunWithResponse(testProfileRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestProfileRuns(RequestOptions requestOptions) {
        return this.serviceClient.listTestProfileRuns(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopTestProfileRunWithResponse(String testProfileRunId, RequestOptions requestOptions) {
        return this.serviceClient.stopTestProfileRunWithResponse(testProfileRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginTestProfileRun(String testProfileRunId, BinaryData body, RequestOptions testProfileRunRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (testProfileRunRequestOptions != null) {
            defaultRequestOptions.setContext(testProfileRunRequestOptions.getContext());
        }
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(5L), context -> PollingUtils.getTestProfileRunStatus((BinaryData)this.createOrUpdateTestProfileRunWithResponse(testProfileRunId, body, testProfileRunRequestOptions).getValue()), context -> PollingUtils.getTestProfileRunStatus((BinaryData)this.getTestProfileRunWithResponse(testProfileRunId, defaultRequestOptions).getValue()), (activationResponse, context) -> (BinaryData)this.stopTestProfileRunWithResponse(testProfileRunId, defaultRequestOptions).getValue(), context -> (BinaryData)this.getTestProfileRunWithResponse(testProfileRunId, defaultRequestOptions).getValue());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<TestProfileRun, TestProfileRun> beginTestProfileRun(String testProfileRunId, TestProfileRun testProfileRun) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(5L), context -> PollingUtils.getTestProfileRunStatus(this.createOrUpdateTestProfileRun(testProfileRunId, testProfileRun)), context -> PollingUtils.getTestProfileRunStatus(this.getTestProfileRun(testProfileRunId)), (activationResponse, context) -> this.stopTestProfileRun(testProfileRunId), context -> this.getTestProfileRun(testProfileRunId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestRunAppComponents createOrUpdateAppComponents(String testRunId, TestRunAppComponents body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestRunAppComponentsAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestRunAppComponentsAccessor().prepareModelForJsonMergePatch(body, false);
        return (TestRunAppComponents)((BinaryData)this.createOrUpdateAppComponentsWithResponse(testRunId, bodyInBinaryData, requestOptions).getValue()).toObject(TestRunAppComponents.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTestRun(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTestRunWithResponse(testRunId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestRunAppComponents getAppComponents(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestRunAppComponents)((BinaryData)this.getAppComponentsWithResponse(testRunId, requestOptions).getValue()).toObject(TestRunAppComponents.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestRunServerMetricsConfiguration getServerMetricsConfig(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestRunServerMetricsConfiguration)((BinaryData)this.getServerMetricsConfigWithResponse(testRunId, requestOptions).getValue()).toObject(TestRunServerMetricsConfiguration.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LoadTestRun getTestRun(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return (LoadTestRun)((BinaryData)this.getTestRunWithResponse(testRunId, requestOptions).getValue()).toObject(LoadTestRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestRunFileInfo getTestRunFile(String testRunId, String fileName) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestRunFileInfo)((BinaryData)this.getTestRunFileWithResponse(testRunId, fileName, requestOptions).getValue()).toObject(TestRunFileInfo.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listMetricDimensionValues(String testRunId, String name, String metricname, String metricNamespace, String timespan, TimeGrain interval) {
        RequestOptions requestOptions = new RequestOptions();
        if (interval != null) {
            requestOptions.addQueryParam("interval", interval.toString(), false);
        }
        return this.serviceClient.listMetricDimensionValues(testRunId, name, metricname, metricNamespace, timespan, requestOptions).mapPage(bodyItemValue -> (String)bodyItemValue.toObject(String.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listMetricDimensionValues(String testRunId, String name, String metricname, String metricNamespace, String timespan) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listMetricDimensionValues(testRunId, name, metricname, metricNamespace, timespan, requestOptions).mapPage(bodyItemValue -> (String)bodyItemValue.toObject(String.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricDefinitions getMetricDefinitions(String testRunId, String metricNamespace) {
        RequestOptions requestOptions = new RequestOptions();
        return (MetricDefinitions)((BinaryData)this.getMetricDefinitionsWithResponse(testRunId, metricNamespace, requestOptions).getValue()).toObject(MetricDefinitions.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public MetricNamespaces getMetricNamespaces(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return (MetricNamespaces)((BinaryData)this.getMetricNamespacesWithResponse(testRunId, requestOptions).getValue()).toObject(MetricNamespaces.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LoadTestRun> listTestRuns() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTestRuns(requestOptions).mapPage(bodyItemValue -> (LoadTestRun)bodyItemValue.toObject(LoadTestRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LoadTestRun stopTestRun(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return (LoadTestRun)((BinaryData)this.stopTestRunWithResponse(testRunId, requestOptions).getValue()).toObject(LoadTestRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    TestProfileRun createOrUpdateTestProfileRun(String testProfileRunId, TestProfileRun body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestProfileRunAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestProfileRunAccessor().prepareModelForJsonMergePatch(body, false);
        return (TestProfileRun)((BinaryData)this.createOrUpdateTestProfileRunWithResponse(testProfileRunId, bodyInBinaryData, requestOptions).getValue()).toObject(TestProfileRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTestProfileRun(String testProfileRunId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTestProfileRunWithResponse(testProfileRunId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestProfileRun getTestProfileRun(String testProfileRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestProfileRun)((BinaryData)this.getTestProfileRunWithResponse(testProfileRunId, requestOptions).getValue()).toObject(TestProfileRun.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TestProfileRun> listTestProfileRuns() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTestProfileRuns(requestOptions).mapPage(bodyItemValue -> (TestProfileRun)bodyItemValue.toObject(TestProfileRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestProfileRun stopTestProfileRun(String testProfileRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestProfileRun)((BinaryData)this.stopTestProfileRunWithResponse(testProfileRunId, requestOptions).getValue()).toObject(TestProfileRun.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetricDimensionValues(String testRunId, String name, String metricname, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return this.serviceClient.listMetricDimensionValues(testRunId, name, metricname, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TestProfileRun> listTestProfileRuns(OffsetDateTime minStartDateTime, OffsetDateTime maxStartDateTime, OffsetDateTime minEndDateTime, OffsetDateTime maxEndDateTime, OffsetDateTime createdDateStartTime, OffsetDateTime createdDateEndTime, List<String> testProfileRunIds, List<String> testProfileIds, List<String> statuses) {
        RequestOptions requestOptions = new RequestOptions();
        if (minStartDateTime != null) {
            requestOptions.addQueryParam("minStartDateTime", String.valueOf(minStartDateTime), false);
        }
        if (maxStartDateTime != null) {
            requestOptions.addQueryParam("maxStartDateTime", String.valueOf(maxStartDateTime), false);
        }
        if (minEndDateTime != null) {
            requestOptions.addQueryParam("minEndDateTime", String.valueOf(minEndDateTime), false);
        }
        if (maxEndDateTime != null) {
            requestOptions.addQueryParam("maxEndDateTime", String.valueOf(maxEndDateTime), false);
        }
        if (createdDateStartTime != null) {
            requestOptions.addQueryParam("createdDateStartTime", String.valueOf(createdDateStartTime), false);
        }
        if (createdDateEndTime != null) {
            requestOptions.addQueryParam("createdDateEndTime", String.valueOf(createdDateEndTime), false);
        }
        if (testProfileRunIds != null) {
            requestOptions.addQueryParam("testProfileRunIds", testProfileRunIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (testProfileIds != null) {
            requestOptions.addQueryParam("testProfileIds", testProfileIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (statuses != null) {
            requestOptions.addQueryParam("statuses", statuses.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listTestProfileRuns(requestOptions).mapPage(bodyItemValue -> (TestProfileRun)bodyItemValue.toObject(TestProfileRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestRunServerMetricsConfiguration createOrUpdateServerMetricsConfig(String testRunId, TestRunServerMetricsConfiguration body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestRunServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestRunServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, false);
        return (TestRunServerMetricsConfiguration)((BinaryData)this.createOrUpdateServerMetricsConfigWithResponse(testRunId, bodyInBinaryData, requestOptions).getValue()).toObject(TestRunServerMetricsConfiguration.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    LoadTestRun createOrUpdateTestRun(String testRunId, LoadTestRun body, String oldTestRunId) {
        RequestOptions requestOptions = new RequestOptions();
        if (oldTestRunId != null) {
            requestOptions.addQueryParam("oldTestRunId", oldTestRunId, false);
        }
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, false);
        return (LoadTestRun)((BinaryData)this.createOrUpdateTestRunWithResponse(testRunId, bodyInBinaryData, requestOptions).getValue()).toObject(LoadTestRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    LoadTestRun createOrUpdateTestRun(String testRunId, LoadTestRun body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, false);
        return (LoadTestRun)((BinaryData)this.createOrUpdateTestRunWithResponse(testRunId, bodyInBinaryData, requestOptions).getValue()).toObject(LoadTestRun.class);
    }

    LoadTestRunClient(LoadTestRunClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LoadTestRun> listTestRuns(String orderBy, String search, String testId, OffsetDateTime executionFrom, OffsetDateTime executionTo, String status, List<String> createdByTypes) {
        RequestOptions requestOptions = new RequestOptions();
        if (orderBy != null) {
            requestOptions.addQueryParam("orderby", orderBy, false);
        }
        if (search != null) {
            requestOptions.addQueryParam("search", search, false);
        }
        if (testId != null) {
            requestOptions.addQueryParam("testId", testId, false);
        }
        if (executionFrom != null) {
            requestOptions.addQueryParam("executionFrom", String.valueOf(executionFrom), false);
        }
        if (executionTo != null) {
            requestOptions.addQueryParam("executionTo", String.valueOf(executionTo), false);
        }
        if (status != null) {
            requestOptions.addQueryParam("status", status, false);
        }
        if (createdByTypes != null) {
            requestOptions.addQueryParam("createdByTypes", createdByTypes.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listTestRuns(requestOptions).mapPage(bodyItemValue -> (LoadTestRun)bodyItemValue.toObject(LoadTestRun.class));
    }
}

