/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.developer.loadtesting.LoadTestRunClientBuilder;
import com.azure.developer.loadtesting.PollingUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.implementation.LoadTestRunClientImpl;
import com.azure.developer.loadtesting.models.LoadTestRun;
import com.azure.developer.loadtesting.models.MetricDefinitions;
import com.azure.developer.loadtesting.models.MetricNamespaces;
import com.azure.developer.loadtesting.models.TestProfileRun;
import com.azure.developer.loadtesting.models.TestRunAppComponents;
import com.azure.developer.loadtesting.models.TestRunFileInfo;
import com.azure.developer.loadtesting.models.TestRunServerMetricsConfiguration;
import com.azure.developer.loadtesting.models.TimeGrain;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=LoadTestRunClientBuilder.class, isAsync=true)
public final class LoadTestRunAsyncClient {
    private final LoadTestRunClientImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateServerMetricsConfigWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponseAsync(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginTestRun(String testRunId, BinaryData body, RequestOptions testRunRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (testRunRequestOptions != null) {
            defaultRequestOptions.setContext(testRunRequestOptions.getContext());
        }
        return new PollerFlux(Duration.ofSeconds(5L), context -> this.createOrUpdateTestRunWithResponse(testRunId, body, testRunRequestOptions).flatMap(FluxUtil::toMono), context -> this.getTestRunWithResponse(testRunId, defaultRequestOptions).flatMap(FluxUtil::toMono).flatMap(testRunBinary -> PollingUtils.getPollResponseMono(() -> PollingUtils.getTestRunStatus(testRunBinary))), (activationResponse, context) -> this.stopTestRunWithResponse(testRunId, defaultRequestOptions).flatMap(FluxUtil::toMono), context -> this.getTestRunWithResponse(testRunId, defaultRequestOptions).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<LoadTestRun, LoadTestRun> beginTestRun(String testRunId, LoadTestRun body) {
        return new PollerFlux(Duration.ofSeconds(5L), context -> this.createOrUpdateTestRun(testRunId, body), context -> this.getTestRun(testRunId).flatMap(testRunBinary -> PollingUtils.getPollResponseMono(() -> PollingUtils.getTestRunStatus(testRunBinary))), (activationResponse, context) -> this.stopTestRun(testRunId), context -> this.getTestRun(testRunId));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginTestProfileRun(String testProfileRunId, BinaryData body, RequestOptions testProfileRunRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (testProfileRunRequestOptions != null) {
            defaultRequestOptions.setContext(testProfileRunRequestOptions.getContext());
        }
        return new PollerFlux(Duration.ofSeconds(5L), context -> this.createOrUpdateTestProfileRunWithResponse(testProfileRunId, body, testProfileRunRequestOptions).flatMap(FluxUtil::toMono), context -> this.getTestRunWithResponse(testProfileRunId, defaultRequestOptions).flatMap(FluxUtil::toMono).flatMap(testRunBinary -> PollingUtils.getPollResponseMono(() -> PollingUtils.getTestRunStatus(testRunBinary))), (activationResponse, context) -> this.stopTestRunWithResponse(testProfileRunId, defaultRequestOptions).flatMap(FluxUtil::toMono), context -> this.getTestRunWithResponse(testProfileRunId, defaultRequestOptions).flatMap(FluxUtil::toMono));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<TestProfileRun, TestProfileRun> beginTestProfileRun(String testProfileRunId, TestProfileRun body) {
        return new PollerFlux(Duration.ofSeconds(5L), context -> this.createOrUpdateTestProfileRun(testProfileRunId, body), context -> this.getTestProfileRun(testProfileRunId).flatMap(testProfileRunBinary -> PollingUtils.getPollResponseMono(() -> PollingUtils.getTestProfileRunStatus(testProfileRunBinary))), (activationResponse, context) -> this.stopTestProfileRun(testProfileRunId), context -> this.getTestProfileRun(testProfileRunId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createOrUpdateAppComponentsWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponseAsync(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetrics(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        return this.serviceClient.listMetricsAsync(testRunId, metricName, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAppComponentsWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getServerMetricsConfigWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> createOrUpdateTestRunWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestRunWithResponseAsync(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestRunWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestRunFileWithResponse(String testRunId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunFileWithResponseAsync(testRunId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestRuns(RequestOptions requestOptions) {
        return this.serviceClient.listTestRunsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.stopTestRunWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricNamespacesWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getMetricNamespacesWithResponseAsync(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getMetricDefinitionsWithResponse(String testRunId, String metricNamespace, RequestOptions requestOptions) {
        return this.serviceClient.getMetricDefinitionsWithResponseAsync(testRunId, metricNamespace, requestOptions);
    }

    LoadTestRunAsyncClient(LoadTestRunClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> createOrUpdateTestProfileRunWithResponse(String testProfileRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestProfileRunWithResponseAsync(testProfileRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTestProfileRunWithResponse(String testProfileRunId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestProfileRunWithResponseAsync(testProfileRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getTestProfileRunWithResponse(String testProfileRunId, RequestOptions requestOptions) {
        return this.serviceClient.getTestProfileRunWithResponseAsync(testProfileRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listTestProfileRuns(RequestOptions requestOptions) {
        return this.serviceClient.listTestProfileRunsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> stopTestProfileRunWithResponse(String testProfileRunId, RequestOptions requestOptions) {
        return this.serviceClient.stopTestProfileRunWithResponseAsync(testProfileRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestRunAppComponents> createOrUpdateAppComponents(String testRunId, TestRunAppComponents body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestRunAppComponentsAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestRunAppComponentsAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateAppComponentsWithResponse(testRunId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestRunAppComponents)protocolMethodData.toObject(TestRunAppComponents.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTestRun(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTestRunWithResponse(testRunId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestRunAppComponents> getAppComponents(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAppComponentsWithResponse(testRunId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestRunAppComponents)protocolMethodData.toObject(TestRunAppComponents.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestRunServerMetricsConfiguration> getServerMetricsConfig(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getServerMetricsConfigWithResponse(testRunId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestRunServerMetricsConfiguration)protocolMethodData.toObject(TestRunServerMetricsConfiguration.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LoadTestRun> getTestRun(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTestRunWithResponse(testRunId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (LoadTestRun)protocolMethodData.toObject(LoadTestRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestRunFileInfo> getTestRunFile(String testRunId, String fileName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTestRunFileWithResponse(testRunId, fileName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestRunFileInfo)protocolMethodData.toObject(TestRunFileInfo.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listMetricDimensionValues(String testRunId, String name, String metricname, String metricNamespace, String timespan, TimeGrain interval) {
        RequestOptions requestOptions = new RequestOptions();
        if (interval != null) {
            requestOptions.addQueryParam("interval", interval.toString(), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listMetricDimensionValues(testRunId, name, metricname, metricNamespace, timespan, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (String)protocolMethodData.toObject(String.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listMetricDimensionValues(String testRunId, String name, String metricname, String metricNamespace, String timespan) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listMetricDimensionValues(testRunId, name, metricname, metricNamespace, timespan, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (String)protocolMethodData.toObject(String.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricDefinitions> getMetricDefinitions(String testRunId, String metricNamespace) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getMetricDefinitionsWithResponse(testRunId, metricNamespace, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (MetricDefinitions)protocolMethodData.toObject(MetricDefinitions.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MetricNamespaces> getMetricNamespaces(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getMetricNamespacesWithResponse(testRunId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (MetricNamespaces)protocolMethodData.toObject(MetricNamespaces.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LoadTestRun> listTestRuns() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTestRuns(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (LoadTestRun)protocolMethodData.toObject(LoadTestRun.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LoadTestRun> stopTestRun(String testRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.stopTestRunWithResponse(testRunId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (LoadTestRun)protocolMethodData.toObject(LoadTestRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<TestProfileRun> createOrUpdateTestProfileRun(String testProfileRunId, TestProfileRun body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestProfileRunAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestProfileRunAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateTestProfileRunWithResponse(testProfileRunId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestProfileRun)protocolMethodData.toObject(TestProfileRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTestProfileRun(String testProfileRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteTestProfileRunWithResponse(testProfileRunId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestProfileRun> getTestProfileRun(String testProfileRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getTestProfileRunWithResponse(testProfileRunId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestProfileRun)protocolMethodData.toObject(TestProfileRun.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TestProfileRun> listTestProfileRuns() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listTestProfileRuns(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (TestProfileRun)protocolMethodData.toObject(TestProfileRun.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestProfileRun> stopTestProfileRun(String testProfileRunId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.stopTestProfileRunWithResponse(testProfileRunId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestProfileRun)protocolMethodData.toObject(TestProfileRun.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listMetricDimensionValues(String testRunId, String name, String metricname, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return this.serviceClient.listMetricDimensionValuesAsync(testRunId, name, metricname, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TestProfileRun> listTestProfileRuns(OffsetDateTime minStartDateTime, OffsetDateTime maxStartDateTime, OffsetDateTime minEndDateTime, OffsetDateTime maxEndDateTime, OffsetDateTime createdDateStartTime, OffsetDateTime createdDateEndTime, List<String> testProfileRunIds, List<String> testProfileIds, List<String> statuses) {
        RequestOptions requestOptions = new RequestOptions();
        if (minStartDateTime != null) {
            requestOptions.addQueryParam("minStartDateTime", String.valueOf(minStartDateTime), false);
        }
        if (maxStartDateTime != null) {
            requestOptions.addQueryParam("maxStartDateTime", String.valueOf(maxStartDateTime), false);
        }
        if (minEndDateTime != null) {
            requestOptions.addQueryParam("minEndDateTime", String.valueOf(minEndDateTime), false);
        }
        if (maxEndDateTime != null) {
            requestOptions.addQueryParam("maxEndDateTime", String.valueOf(maxEndDateTime), false);
        }
        if (createdDateStartTime != null) {
            requestOptions.addQueryParam("createdDateStartTime", String.valueOf(createdDateStartTime), false);
        }
        if (createdDateEndTime != null) {
            requestOptions.addQueryParam("createdDateEndTime", String.valueOf(createdDateEndTime), false);
        }
        if (testProfileRunIds != null) {
            requestOptions.addQueryParam("testProfileRunIds", testProfileRunIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (testProfileIds != null) {
            requestOptions.addQueryParam("testProfileIds", testProfileIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (statuses != null) {
            requestOptions.addQueryParam("statuses", statuses.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTestProfileRuns(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (TestProfileRun)protocolMethodData.toObject(TestProfileRun.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TestRunServerMetricsConfiguration> createOrUpdateServerMetricsConfig(String testRunId, TestRunServerMetricsConfiguration body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestRunServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestRunServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateServerMetricsConfigWithResponse(testRunId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (TestRunServerMetricsConfiguration)protocolMethodData.toObject(TestRunServerMetricsConfiguration.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<LoadTestRun> createOrUpdateTestRun(String testRunId, LoadTestRun body, String oldTestRunId) {
        RequestOptions requestOptions = new RequestOptions();
        if (oldTestRunId != null) {
            requestOptions.addQueryParam("oldTestRunId", oldTestRunId, false);
        }
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateTestRunWithResponse(testRunId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (LoadTestRun)protocolMethodData.toObject(LoadTestRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<LoadTestRun> createOrUpdateTestRun(String testRunId, LoadTestRun body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getLoadTestRunAccessor().prepareModelForJsonMergePatch(body, false);
        return this.createOrUpdateTestRunWithResponse(testRunId, bodyInBinaryData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (LoadTestRun)protocolMethodData.toObject(LoadTestRun.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LoadTestRun> listTestRuns(String orderBy, String search, String testId, OffsetDateTime executionFrom, OffsetDateTime executionTo, String status, List<String> createdByTypes) {
        RequestOptions requestOptions = new RequestOptions();
        if (orderBy != null) {
            requestOptions.addQueryParam("orderby", orderBy, false);
        }
        if (search != null) {
            requestOptions.addQueryParam("search", search, false);
        }
        if (testId != null) {
            requestOptions.addQueryParam("testId", testId, false);
        }
        if (executionFrom != null) {
            requestOptions.addQueryParam("executionFrom", String.valueOf(executionFrom), false);
        }
        if (executionTo != null) {
            requestOptions.addQueryParam("executionTo", String.valueOf(executionTo), false);
        }
        if (status != null) {
            requestOptions.addQueryParam("status", status, false);
        }
        if (createdByTypes != null) {
            requestOptions.addQueryParam("createdByTypes", createdByTypes.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listTestRuns(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (LoadTestRun)protocolMethodData.toObject(LoadTestRun.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }
}

