/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.loadtesting.LoadTestAdministrationClientBuilder;
import com.azure.developer.loadtesting.PollingUtils;
import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.implementation.LoadTestAdministrationClientImpl;
import com.azure.developer.loadtesting.models.LoadTest;
import com.azure.developer.loadtesting.models.LoadTestingFileType;
import com.azure.developer.loadtesting.models.TestAppComponents;
import com.azure.developer.loadtesting.models.TestFileInfo;
import com.azure.developer.loadtesting.models.TestProfile;
import com.azure.developer.loadtesting.models.TestServerMetricsConfiguration;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ServiceClient(builder=LoadTestAdministrationClientBuilder.class)
public final class LoadTestAdministrationClient {
    private static final ClientLogger LOGGER = new ClientLogger(LoadTestAdministrationClient.class);
    private final LoadTestAdministrationClientImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateServerMetricsConfigWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponse(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginUploadTestFile(String testId, String fileName, BinaryData body, RequestOptions fileUploadRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (fileUploadRequestOptions != null) {
            defaultRequestOptions.setContext(fileUploadRequestOptions.getContext());
        }
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(2L), context -> PollingUtils.getValidationStatus((BinaryData)this.uploadTestFileWithResponse(testId, fileName, body, fileUploadRequestOptions).getValue()), context -> PollingUtils.getValidationStatus((BinaryData)this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).getValue()), (activationResponse, context) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, context -> (BinaryData)this.getTestFileWithResponse(testId, fileName, defaultRequestOptions).getValue());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<TestFileInfo, TestFileInfo> beginUploadTestFile(String testId, String fileName, BinaryData body) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(2L), context -> PollingUtils.getValidationStatus(this.uploadTestFile(testId, fileName, body)), context -> PollingUtils.getValidationStatus(this.getTestFile(testId, fileName)), (activationResponse, context) -> {
            throw LOGGER.logExceptionAsError(new RuntimeException("Cancellation is not supported"));
        }, context -> this.getTestFile(testId, fileName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestFiles(String testId, RequestOptions requestOptions) {
        return this.serviceClient.listTestFiles(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateTestWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestWithResponse(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestWithResponse(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getTestWithResponse(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTests(RequestOptions requestOptions) {
        return this.serviceClient.listTests(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> uploadTestFileWithResponse(String testId, String fileName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.uploadTestFileWithResponse(testId, fileName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestFileWithResponse(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestFileWithResponse(String testId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestFileWithResponse(testId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateAppComponentsWithResponse(String testId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponse(testId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAppComponentsWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponse(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getServerMetricsConfigWithResponse(String testId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponse(testId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateTestProfileWithResponse(String testProfileId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestProfileWithResponse(testProfileId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestProfileWithResponse(String testProfileId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestProfileWithResponse(testProfileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestProfileWithResponse(String testProfileId, RequestOptions requestOptions) {
        return this.serviceClient.getTestProfileWithResponse(testProfileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestProfiles(RequestOptions requestOptions) {
        return this.serviceClient.listTestProfiles(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestAppComponents createOrUpdateAppComponents(String testId, TestAppComponents body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestAppComponentsAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestAppComponentsAccessor().prepareModelForJsonMergePatch(body, false);
        return (TestAppComponents)((BinaryData)this.createOrUpdateAppComponentsWithResponse(testId, bodyInBinaryData, requestOptions).getValue()).toObject(TestAppComponents.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestAppComponents getAppComponents(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestAppComponents)((BinaryData)this.getAppComponentsWithResponse(testId, requestOptions).getValue()).toObject(TestAppComponents.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestServerMetricsConfiguration getServerMetricsConfig(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestServerMetricsConfiguration)((BinaryData)this.getServerMetricsConfigWithResponse(testId, requestOptions).getValue()).toObject(TestServerMetricsConfiguration.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LoadTest getTest(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return (LoadTest)((BinaryData)this.getTestWithResponse(testId, requestOptions).getValue()).toObject(LoadTest.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestFileInfo getTestFile(String testId, String fileName) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestFileInfo)((BinaryData)this.getTestFileWithResponse(testId, fileName, requestOptions).getValue()).toObject(TestFileInfo.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TestFileInfo> listTestFiles(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTestFiles(testId, requestOptions).mapPage(bodyItemValue -> (TestFileInfo)bodyItemValue.toObject(TestFileInfo.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LoadTest> listTests(String orderBy, String search, OffsetDateTime lastModifiedStartTime, OffsetDateTime lastModifiedEndTime) {
        RequestOptions requestOptions = new RequestOptions();
        if (orderBy != null) {
            requestOptions.addQueryParam("orderby", orderBy, false);
        }
        if (search != null) {
            requestOptions.addQueryParam("search", search, false);
        }
        if (lastModifiedStartTime != null) {
            requestOptions.addQueryParam("lastModifiedStartTime", String.valueOf(lastModifiedStartTime), false);
        }
        if (lastModifiedEndTime != null) {
            requestOptions.addQueryParam("lastModifiedEndTime", String.valueOf(lastModifiedEndTime), false);
        }
        return this.serviceClient.listTests(requestOptions).mapPage(bodyItemValue -> (LoadTest)bodyItemValue.toObject(LoadTest.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LoadTest> listTests() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTests(requestOptions).mapPage(bodyItemValue -> (LoadTest)bodyItemValue.toObject(LoadTest.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    TestFileInfo uploadTestFile(String testId, String fileName, BinaryData body) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestFileInfo)((BinaryData)this.uploadTestFileWithResponse(testId, fileName, body, requestOptions).getValue()).toObject(TestFileInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTestFile(String testId, String fileName) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTestFileWithResponse(testId, fileName, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTest(String testId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTestWithResponse(testId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestProfile createOrUpdateTestProfile(String testProfileId, TestProfile body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestProfileAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestProfileAccessor().prepareModelForJsonMergePatch(body, false);
        return (TestProfile)((BinaryData)this.createOrUpdateTestProfileWithResponse(testProfileId, bodyInBinaryData, requestOptions).getValue()).toObject(TestProfile.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTestProfile(String testProfileId) {
        RequestOptions requestOptions = new RequestOptions();
        this.deleteTestProfileWithResponse(testProfileId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestProfile getTestProfile(String testProfileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (TestProfile)((BinaryData)this.getTestProfileWithResponse(testProfileId, requestOptions).getValue()).toObject(TestProfile.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TestProfile> listTestProfiles() {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listTestProfiles(requestOptions).mapPage(bodyItemValue -> (TestProfile)bodyItemValue.toObject(TestProfile.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TestProfile> listTestProfiles(OffsetDateTime lastModifiedStartTime, OffsetDateTime lastModifiedEndTime, List<String> testProfileIds, List<String> testIds) {
        RequestOptions requestOptions = new RequestOptions();
        if (lastModifiedStartTime != null) {
            requestOptions.addQueryParam("lastModifiedStartTime", String.valueOf(lastModifiedStartTime), false);
        }
        if (lastModifiedEndTime != null) {
            requestOptions.addQueryParam("lastModifiedEndTime", String.valueOf(lastModifiedEndTime), false);
        }
        if (testProfileIds != null) {
            requestOptions.addQueryParam("testProfileIds", testProfileIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (testIds != null) {
            requestOptions.addQueryParam("testIds", testIds.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return this.serviceClient.listTestProfiles(requestOptions).mapPage(bodyItemValue -> (TestProfile)bodyItemValue.toObject(TestProfile.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TestServerMetricsConfiguration createOrUpdateServerMetricsConfig(String testId, TestServerMetricsConfiguration body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getTestServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getTestServerMetricsConfigurationAccessor().prepareModelForJsonMergePatch(body, false);
        return (TestServerMetricsConfiguration)((BinaryData)this.createOrUpdateServerMetricsConfigWithResponse(testId, bodyInBinaryData, requestOptions).getValue()).toObject(TestServerMetricsConfiguration.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LoadTest createOrUpdateTest(String testId, LoadTest body) {
        RequestOptions requestOptions = new RequestOptions();
        JsonMergePatchHelper.getLoadTestAccessor().prepareModelForJsonMergePatch(body, true);
        BinaryData bodyInBinaryData = BinaryData.fromObject((Object)body);
        bodyInBinaryData.getLength();
        JsonMergePatchHelper.getLoadTestAccessor().prepareModelForJsonMergePatch(body, false);
        return (LoadTest)((BinaryData)this.createOrUpdateTestWithResponse(testId, bodyInBinaryData, requestOptions).getValue()).toObject(LoadTest.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    TestFileInfo uploadTestFile(String testId, String fileName, BinaryData body, LoadTestingFileType fileType) {
        RequestOptions requestOptions = new RequestOptions();
        if (fileType != null) {
            requestOptions.addQueryParam("fileType", fileType.toString(), false);
        }
        return (TestFileInfo)((BinaryData)this.uploadTestFileWithResponse(testId, fileName, body, requestOptions).getValue()).toObject(TestFileInfo.class);
    }

    LoadTestAdministrationClient(LoadTestAdministrationClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }
}

