/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.loadtesting.LoadTestRunClientBuilder;
import com.azure.developer.loadtesting.PollingUtils;
import com.azure.developer.loadtesting.implementation.LoadTestRunsImpl;
import java.time.Duration;

@ServiceClient(builder=LoadTestRunClientBuilder.class)
public final class LoadTestRunClient {
    private final LoadTestRunsImpl serviceClient;

    LoadTestRunClient(LoadTestRunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateServerMetricsConfigWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateServerMetricsConfigWithResponse(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginTestRun(String testRunId, BinaryData body, RequestOptions testRunRequestOptions) {
        RequestOptions defaultRequestOptions = new RequestOptions();
        if (testRunRequestOptions != null) {
            defaultRequestOptions.setContext(testRunRequestOptions.getContext());
        }
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(5L), context -> PollingUtils.getTestRunStatus((BinaryData)this.createOrUpdateTestRunWithResponse(testRunId, body, testRunRequestOptions).getValue()), context -> PollingUtils.getTestRunStatus((BinaryData)this.getTestRunWithResponse(testRunId, defaultRequestOptions).getValue()), (activationResponse, context) -> (BinaryData)this.stopTestRunWithResponse(testRunId, defaultRequestOptions).getValue(), context -> (BinaryData)this.getTestRunWithResponse(testRunId, defaultRequestOptions).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createOrUpdateAppComponentsWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateAppComponentsWithResponse(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetrics(String testRunId, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        if (requestOptions == null) {
            requestOptions = new RequestOptions();
        }
        requestOptions.setHeader(HttpHeaderName.CONTENT_TYPE, "application/json");
        return this.serviceClient.listMetrics(testRunId, metricName, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listMetricDimensionValues(String testRunId, String name, String metricName, String metricNamespace, String timespan, RequestOptions requestOptions) {
        return this.serviceClient.listMetricDimensionValues(testRunId, name, metricName, metricNamespace, timespan, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getAppComponentsWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getAppComponentsWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getServerMetricsConfigWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getServerMetricsConfigWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> createOrUpdateTestRunWithResponse(String testRunId, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.createOrUpdateTestRunWithResponse(testRunId, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.deleteTestRunWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getTestRunFileWithResponse(String testRunId, String fileName, RequestOptions requestOptions) {
        return this.serviceClient.getTestRunFileWithResponse(testRunId, fileName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listTestRuns(RequestOptions requestOptions) {
        return this.serviceClient.listTestRuns(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> stopTestRunWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.stopTestRunWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricNamespacesWithResponse(String testRunId, RequestOptions requestOptions) {
        return this.serviceClient.getMetricNamespacesWithResponse(testRunId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getMetricDefinitionsWithResponse(String testRunId, String metricNamespace, RequestOptions requestOptions) {
        return this.serviceClient.getMetricDefinitionsWithResponse(testRunId, metricNamespace, requestOptions);
    }
}

