/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import reactor.core.publisher.Mono;

final class PollingUtils {
    PollingUtils() {
    }

    static <T> Mono<PollResponse<T>> getPollResponseMono(Callable<PollResponse<T>> pollOperation) {
        try {
            return Mono.just(pollOperation.call());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    static PollResponse<BinaryData> getValidationStatus(BinaryData fileBinary) throws RuntimeException {
        LongRunningOperationStatus lroStatus;
        String validationStatus;
        try (JsonReader jsonReader = JsonProviders.createReader((byte[])fileBinary.toBytes());){
            Map jsonTree = jsonReader.readMap(JsonReader::readUntyped);
            validationStatus = jsonTree.get("validationStatus").toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered exception while retrieving validation status", e);
        }
        switch (validationStatus) {
            case "VALIDATION_NOT_REQUIRED": 
            case "VALIDATION_SUCCESS": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "VALIDATION_FAILURE": {
                lroStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case "VALIDATION_INITIATED": {
                lroStatus = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case "NOT_VALIDATED": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            default: {
                lroStatus = LongRunningOperationStatus.NOT_STARTED;
            }
        }
        return new PollResponse(lroStatus, (Object)fileBinary);
    }

    static PollResponse<BinaryData> getTestRunStatus(BinaryData testRunBinary) throws RuntimeException {
        LongRunningOperationStatus lroStatus;
        String status;
        try (JsonReader jsonReader = JsonProviders.createReader((byte[])testRunBinary.toBytes());){
            Map jsonTree = jsonReader.readMap(JsonReader::readUntyped);
            status = jsonTree.get("status").toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered exception while retrieving test run status", e);
        }
        switch (status) {
            case "NOTSTARTED": {
                lroStatus = LongRunningOperationStatus.NOT_STARTED;
                break;
            }
            case "DONE": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "FAILED": {
                lroStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case "CANCELLED": {
                lroStatus = LongRunningOperationStatus.USER_CANCELLED;
                break;
            }
            default: {
                lroStatus = LongRunningOperationStatus.IN_PROGRESS;
            }
        }
        return new PollResponse(lroStatus, (Object)testRunBinary);
    }
}

