/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.developer.devcenter.DevBoxesClientBuilder;
import com.azure.developer.devcenter.implementation.DevBoxesClientImpl;
import com.azure.developer.devcenter.models.DevBox;
import com.azure.developer.devcenter.models.DevBoxAction;
import com.azure.developer.devcenter.models.DevBoxActionDelayResult;
import com.azure.developer.devcenter.models.DevBoxPool;
import com.azure.developer.devcenter.models.DevBoxSchedule;
import com.azure.developer.devcenter.models.DevCenterOperationDetails;
import com.azure.developer.devcenter.models.RemoteConnection;
import java.time.OffsetDateTime;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DevBoxesClientBuilder.class, isAsync=true)
public final class DevBoxesAsyncClient {
    private final DevBoxesClientImpl serviceClient;

    DevBoxesAsyncClient(DevBoxesClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPools(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listPoolsAsync(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getPoolWithResponse(String projectName, String poolName, RequestOptions requestOptions) {
        return this.serviceClient.getPoolWithResponseAsync(projectName, poolName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSchedules(String projectName, String poolName, RequestOptions requestOptions) {
        return this.serviceClient.listSchedulesAsync(projectName, poolName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getScheduleWithResponse(String projectName, String poolName, String scheduleName, RequestOptions requestOptions) {
        return this.serviceClient.getScheduleWithResponseAsync(projectName, poolName, scheduleName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAllDevBoxes(RequestOptions requestOptions) {
        return this.serviceClient.listAllDevBoxesAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAllDevBoxesByUser(String userId, RequestOptions requestOptions) {
        return this.serviceClient.listAllDevBoxesByUserAsync(userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevBoxes(String projectName, String userId, RequestOptions requestOptions) {
        return this.serviceClient.listDevBoxesAsync(projectName, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDevBoxWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.getDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCreateDevBox(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.beginCreateDevBoxAsync(projectName, userId, devBoxName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, Void> beginDeleteDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginDeleteDevBoxAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginStartDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginStartDevBoxAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginStopDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginStopDevBoxAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginRestartDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.beginRestartDevBoxAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRemoteConnectionWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.getRemoteConnectionWithResponseAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevBoxActions(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return this.serviceClient.listDevBoxActionsAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDevBoxActionWithResponse(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        return this.serviceClient.getDevBoxActionWithResponseAsync(projectName, userId, devBoxName, actionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> skipActionWithResponse(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        return this.serviceClient.skipActionWithResponseAsync(projectName, userId, devBoxName, actionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> delayActionWithResponse(String projectName, String userId, String devBoxName, String actionName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        return this.serviceClient.delayActionWithResponseAsync(projectName, userId, devBoxName, actionName, delayUntil, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> delayAllActions(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        return this.serviceClient.delayAllActionsAsync(projectName, userId, devBoxName, delayUntil, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevBoxPool> listPools(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listPools(projectName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevBoxPool)protocolMethodData.toObject(DevBoxPool.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevBoxPool> getPool(String projectName, String poolName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getPoolWithResponse(projectName, poolName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevBoxPool)protocolMethodData.toObject(DevBoxPool.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevBoxSchedule> listSchedules(String projectName, String poolName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listSchedules(projectName, poolName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevBoxSchedule)protocolMethodData.toObject(DevBoxSchedule.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevBoxSchedule> getSchedule(String projectName, String poolName, String scheduleName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getScheduleWithResponse(projectName, poolName, scheduleName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevBoxSchedule)protocolMethodData.toObject(DevBoxSchedule.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevBox> listAllDevBoxes() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listAllDevBoxes(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevBox)protocolMethodData.toObject(DevBox.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevBox> listAllDevBoxesByUser(String userId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listAllDevBoxesByUser(userId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevBox)protocolMethodData.toObject(DevBox.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevBox> listDevBoxes(String projectName, String userId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listDevBoxes(projectName, userId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevBox)protocolMethodData.toObject(DevBox.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevBox> getDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getDevBoxWithResponse(projectName, userId, devBoxName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevBox)protocolMethodData.toObject(DevBox.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, DevBox> beginCreateDevBox(String projectName, String userId, DevBox devBox) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCreateDevBoxWithModelAsync(projectName, userId, devBox.getName(), BinaryData.fromObject((Object)devBox), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginDeleteDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginDeleteDevBoxWithModelAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginStartDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginStartDevBoxWithModelAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginStopDevBox(String projectName, String userId, String devBoxName, Boolean hibernate) {
        RequestOptions requestOptions = new RequestOptions();
        if (hibernate != null) {
            requestOptions.addQueryParam("hibernate", String.valueOf(hibernate), false);
        }
        return this.serviceClient.beginStopDevBoxWithModelAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginStopDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginStopDevBoxWithModelAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginRestartDevBox(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginRestartDevBoxWithModelAsync(projectName, userId, devBoxName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoteConnection> getRemoteConnection(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getRemoteConnectionWithResponse(projectName, userId, devBoxName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (RemoteConnection)protocolMethodData.toObject(RemoteConnection.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevBoxAction> listDevBoxActions(String projectName, String userId, String devBoxName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listDevBoxActions(projectName, userId, devBoxName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevBoxAction)protocolMethodData.toObject(DevBoxAction.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevBoxAction> getDevBoxAction(String projectName, String userId, String devBoxName, String actionName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getDevBoxActionWithResponse(projectName, userId, devBoxName, actionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevBoxAction)protocolMethodData.toObject(DevBoxAction.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> skipAction(String projectName, String userId, String devBoxName, String actionName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.skipActionWithResponse(projectName, userId, devBoxName, actionName, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevBoxAction> delayAction(String projectName, String userId, String devBoxName, String actionName, OffsetDateTime delayUntil) {
        RequestOptions requestOptions = new RequestOptions();
        return this.delayActionWithResponse(projectName, userId, devBoxName, actionName, delayUntil, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevBoxAction)protocolMethodData.toObject(DevBoxAction.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevBoxActionDelayResult> delayAllActions(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.delayAllActions(projectName, userId, devBoxName, delayUntil, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevBoxActionDelayResult)protocolMethodData.toObject(DevBoxActionDelayResult.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }
}

