/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.developer.devcenter.models.EnvironmentDefinitionParameterType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class EnvironmentDefinitionParameter
implements JsonSerializable<EnvironmentDefinitionParameter> {
    private final String id;
    private String name;
    private String description;
    private String defaultValue;
    private final EnvironmentDefinitionParameterType parameterType;
    private Boolean readOnly;
    private final boolean required;
    private List<String> allowed;

    private EnvironmentDefinitionParameter(String id, EnvironmentDefinitionParameterType parameterType, boolean required) {
        this.id = id;
        this.parameterType = parameterType;
        this.required = required;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public EnvironmentDefinitionParameterType getParameterType() {
        return this.parameterType;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<String> getAllowed() {
        return this.allowed;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.parameterType == null ? null : this.parameterType.toString());
        jsonWriter.writeBooleanField("required", this.required);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("default", this.defaultValue);
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        jsonWriter.writeArrayField("allowed", this.allowed, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static EnvironmentDefinitionParameter fromJson(JsonReader jsonReader) throws IOException {
        return (EnvironmentDefinitionParameter)jsonReader.readObject(reader -> {
            String id = null;
            EnvironmentDefinitionParameterType parameterType = null;
            boolean required = false;
            String name = null;
            String description = null;
            String defaultValue = null;
            Boolean readOnly = null;
            List allowed = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    parameterType = EnvironmentDefinitionParameterType.fromString(reader.getString());
                    continue;
                }
                if ("required".equals(fieldName)) {
                    required = reader.getBoolean();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("default".equals(fieldName)) {
                    defaultValue = reader.getString();
                    continue;
                }
                if ("readOnly".equals(fieldName)) {
                    readOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowed".equals(fieldName)) {
                    allowed = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            EnvironmentDefinitionParameter deserializedEnvironmentDefinitionParameter = new EnvironmentDefinitionParameter(id, parameterType, required);
            deserializedEnvironmentDefinitionParameter.name = name;
            deserializedEnvironmentDefinitionParameter.description = description;
            deserializedEnvironmentDefinitionParameter.defaultValue = defaultValue;
            deserializedEnvironmentDefinitionParameter.readOnly = readOnly;
            deserializedEnvironmentDefinitionParameter.allowed = allowed;
            return deserializedEnvironmentDefinitionParameter;
        });
    }
}

