/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DevCenterProject
implements JsonSerializable<DevCenterProject> {
    private String name;
    private String description;
    private Integer maxDevBoxesPerUser;

    private DevCenterProject() {
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getMaxDevBoxesPerUser() {
        return this.maxDevBoxesPerUser;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeNumberField("maxDevBoxesPerUser", (Number)this.maxDevBoxesPerUser);
        return jsonWriter.writeEndObject();
    }

    public static DevCenterProject fromJson(JsonReader jsonReader) throws IOException {
        return (DevCenterProject)jsonReader.readObject(reader -> {
            DevCenterProject deserializedDevCenterProject = new DevCenterProject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDevCenterProject.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDevCenterProject.description = reader.getString();
                    continue;
                }
                if ("maxDevBoxesPerUser".equals(fieldName)) {
                    deserializedDevCenterProject.maxDevBoxesPerUser = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDevCenterProject;
        });
    }
}

