/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.core.models.ResponseError;
import com.azure.developer.devcenter.models.DevBoxHardwareProfile;
import com.azure.developer.devcenter.models.DevBoxImageReference;
import com.azure.developer.devcenter.models.DevBoxOsType;
import com.azure.developer.devcenter.models.DevBoxProvisioningState;
import com.azure.developer.devcenter.models.DevBoxStorageProfile;
import com.azure.developer.devcenter.models.HibernateSupport;
import com.azure.developer.devcenter.models.LocalAdministratorStatus;
import com.azure.developer.devcenter.models.PowerState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class DevBox
implements JsonSerializable<DevBox> {
    private String name;
    private String projectName;
    private final String poolName;
    private HibernateSupport hibernateSupport;
    private DevBoxProvisioningState provisioningState;
    private String actionState;
    private PowerState powerState;
    private String uniqueId;
    private ResponseError error;
    private String location;
    private DevBoxOsType osType;
    private String userId;
    private DevBoxHardwareProfile hardwareProfile;
    private DevBoxStorageProfile storageProfile;
    private DevBoxImageReference imageReference;
    private OffsetDateTime createdTime;
    private LocalAdministratorStatus localAdministratorStatus;

    public DevBox(String devBoxName, String poolName) {
        this.name = devBoxName;
        this.poolName = poolName;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public HibernateSupport getHibernateSupport() {
        return this.hibernateSupport;
    }

    public DevBoxProvisioningState getProvisioningState() {
        return this.provisioningState;
    }

    public String getActionState() {
        return this.actionState;
    }

    public PowerState getPowerState() {
        return this.powerState;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public ResponseError getError() {
        return this.error;
    }

    public String getLocation() {
        return this.location;
    }

    public DevBoxOsType getOsType() {
        return this.osType;
    }

    public String getUserId() {
        return this.userId;
    }

    public DevBoxHardwareProfile getHardwareProfile() {
        return this.hardwareProfile;
    }

    public DevBoxStorageProfile getStorageProfile() {
        return this.storageProfile;
    }

    public DevBoxImageReference getImageReference() {
        return this.imageReference;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public LocalAdministratorStatus getLocalAdministratorStatus() {
        return this.localAdministratorStatus;
    }

    public DevBox setLocalAdministratorStatus(LocalAdministratorStatus localAdministratorStatus) {
        this.localAdministratorStatus = localAdministratorStatus;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("poolName", this.poolName);
        jsonWriter.writeStringField("localAdministrator", this.localAdministratorStatus == null ? null : this.localAdministratorStatus.toString());
        return jsonWriter.writeEndObject();
    }

    public static DevBox fromJson(JsonReader jsonReader) throws IOException {
        return (DevBox)jsonReader.readObject(reader -> {
            String name = null;
            String poolName = null;
            String projectName = null;
            HibernateSupport hibernateSupport = null;
            DevBoxProvisioningState provisioningState = null;
            String actionState = null;
            PowerState powerState = null;
            String uniqueId = null;
            ResponseError error = null;
            String location = null;
            DevBoxOsType osType = null;
            String userId = null;
            DevBoxHardwareProfile hardwareProfile = null;
            DevBoxStorageProfile storageProfile = null;
            DevBoxImageReference imageReference = null;
            OffsetDateTime createdTime = null;
            LocalAdministratorStatus localAdministratorStatus = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("poolName".equals(fieldName)) {
                    poolName = reader.getString();
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    projectName = reader.getString();
                    continue;
                }
                if ("hibernateSupport".equals(fieldName)) {
                    hibernateSupport = HibernateSupport.fromString(reader.getString());
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    provisioningState = DevBoxProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("actionState".equals(fieldName)) {
                    actionState = reader.getString();
                    continue;
                }
                if ("powerState".equals(fieldName)) {
                    powerState = PowerState.fromString(reader.getString());
                    continue;
                }
                if ("uniqueId".equals(fieldName)) {
                    uniqueId = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    location = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    osType = DevBoxOsType.fromString(reader.getString());
                    continue;
                }
                if ("user".equals(fieldName)) {
                    userId = reader.getString();
                    continue;
                }
                if ("hardwareProfile".equals(fieldName)) {
                    hardwareProfile = DevBoxHardwareProfile.fromJson(reader);
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    storageProfile = DevBoxStorageProfile.fromJson(reader);
                    continue;
                }
                if ("imageReference".equals(fieldName)) {
                    imageReference = DevBoxImageReference.fromJson(reader);
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("localAdministrator".equals(fieldName)) {
                    localAdministratorStatus = LocalAdministratorStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            DevBox deserializedDevBox = new DevBox(name, poolName);
            deserializedDevBox.projectName = projectName;
            deserializedDevBox.hibernateSupport = hibernateSupport;
            deserializedDevBox.provisioningState = provisioningState;
            deserializedDevBox.actionState = actionState;
            deserializedDevBox.powerState = powerState;
            deserializedDevBox.uniqueId = uniqueId;
            deserializedDevBox.error = error;
            deserializedDevBox.location = location;
            deserializedDevBox.osType = osType;
            deserializedDevBox.userId = userId;
            deserializedDevBox.hardwareProfile = hardwareProfile;
            deserializedDevBox.storageProfile = storageProfile;
            deserializedDevBox.imageReference = imageReference;
            deserializedDevBox.createdTime = createdTime;
            deserializedDevBox.localAdministratorStatus = localAdministratorStatus;
            return deserializedDevBox;
        });
    }
}

