/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DevBoxNextAction
implements JsonSerializable<DevBoxNextAction> {
    private final OffsetDateTime scheduledTime;

    private DevBoxNextAction(OffsetDateTime scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public OffsetDateTime getScheduledTime() {
        return this.scheduledTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scheduledTime", this.scheduledTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledTime));
        return jsonWriter.writeEndObject();
    }

    public static DevBoxNextAction fromJson(JsonReader jsonReader) throws IOException {
        return (DevBoxNextAction)jsonReader.readObject(reader -> {
            OffsetDateTime scheduledTime = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduledTime".equals(fieldName)) {
                    scheduledTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new DevBoxNextAction(scheduledTime);
        });
    }
}

