/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.polling.PollingStrategyOptions;
import com.azure.core.util.polling.SyncDefaultPollingStrategy;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.polling.SyncPollingStrategy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import com.azure.developer.devcenter.DevCenterServiceVersion;
import com.azure.developer.devcenter.models.DevBox;
import com.azure.developer.devcenter.models.DevCenterOperationDetails;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class DevBoxesClientImpl {
    private final DevBoxesClientService service;
    private final String endpoint;
    private final DevCenterServiceVersion serviceVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;

    public String getEndpoint() {
        return this.endpoint;
    }

    public DevCenterServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public DevBoxesClientImpl(String endpoint, DevCenterServiceVersion serviceVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DevBoxesClientImpl(HttpPipeline httpPipeline, String endpoint, DevCenterServiceVersion serviceVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, serviceVersion);
    }

    public DevBoxesClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, DevCenterServiceVersion serviceVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.serviceVersion = serviceVersion;
        this.service = (DevBoxesClientService)RestProxy.create(DevBoxesClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolsSinglePageAsync(String projectName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPools(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listPoolsAsync(String projectName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listPoolsSinglePageAsync(projectName, requestOptions), nextLink -> this.listPoolsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolsSinglePage(String projectName, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listPools(String projectName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listPoolsSinglePage(projectName, requestOptions), nextLink -> this.listPoolsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getPoolWithResponseAsync(String projectName, String poolName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPool(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, poolName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getPoolWithResponse(String projectName, String poolName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getPoolSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, poolName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listSchedulesSinglePageAsync(String projectName, String poolName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSchedules(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, poolName, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listSchedulesAsync(String projectName, String poolName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listSchedulesSinglePageAsync(projectName, poolName, requestOptions), nextLink -> this.listSchedulesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listSchedulesSinglePage(String projectName, String poolName, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listSchedulesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, poolName, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listSchedules(String projectName, String poolName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listSchedulesSinglePage(projectName, poolName, requestOptions), nextLink -> this.listSchedulesNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getScheduleWithResponseAsync(String projectName, String poolName, String scheduleName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSchedule(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, poolName, scheduleName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getScheduleWithResponse(String projectName, String poolName, String scheduleName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getScheduleSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, poolName, scheduleName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listAllDevBoxesSinglePageAsync(RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllDevBoxes(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAllDevBoxesAsync(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listAllDevBoxesSinglePageAsync(requestOptions), nextLink -> this.listAllDevBoxesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listAllDevBoxesSinglePage(RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listAllDevBoxesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAllDevBoxes(RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listAllDevBoxesSinglePage(requestOptions), nextLink -> this.listAllDevBoxesNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listAllDevBoxesByUserSinglePageAsync(String userId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllDevBoxesByUser(this.getEndpoint(), this.getServiceVersion().getVersion(), userId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAllDevBoxesByUserAsync(String userId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listAllDevBoxesByUserSinglePageAsync(userId, requestOptions), nextLink -> this.listAllDevBoxesByUserNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listAllDevBoxesByUserSinglePage(String userId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listAllDevBoxesByUserSync(this.getEndpoint(), this.getServiceVersion().getVersion(), userId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAllDevBoxesByUser(String userId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listAllDevBoxesByUserSinglePage(userId, requestOptions), nextLink -> this.listAllDevBoxesByUserNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listDevBoxesSinglePageAsync(String projectName, String userId, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDevBoxes(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevBoxesAsync(String projectName, String userId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listDevBoxesSinglePageAsync(projectName, userId, requestOptions), nextLink -> this.listDevBoxesNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listDevBoxesSinglePage(String projectName, String userId, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listDevBoxesSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevBoxes(String projectName, String userId, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listDevBoxesSinglePage(projectName, userId, requestOptions), nextLink -> this.listDevBoxesNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDevBoxWithResponseAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDevBox(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDevBoxWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getDevBoxSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> createDevBoxWithResponseAsync(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDevBox(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", "application/json", body, requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createDevBoxWithResponse(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        String contentType = "application/json";
        String accept = "application/json";
        return this.service.createDevBoxSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", "application/json", body, requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCreateDevBoxAsync(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.createDevBoxWithResponseAsync(projectName, userId, devBoxName, body, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCreateDevBox(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.createDevBoxWithResponse(projectName, userId, devBoxName, body, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, DevBox> beginCreateDevBoxWithModelAsync(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.createDevBoxWithResponseAsync(projectName, userId, devBoxName, body, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(DevBox.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, DevBox> beginCreateDevBoxWithModel(String projectName, String userId, String devBoxName, BinaryData body, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.createDevBoxWithResponse(projectName, userId, devBoxName, body, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(DevBox.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> deleteDevBoxWithResponseAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDevBox(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteDevBoxWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.deleteDevBoxSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, Void> beginDeleteDevBoxAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.deleteDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, Void> beginDeleteDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.deleteDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginDeleteDevBoxWithModelAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.deleteDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginDeleteDevBoxWithModel(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.deleteDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> startDevBoxWithResponseAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startDevBox(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> startDevBoxWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.startDevBoxSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginStartDevBoxAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.startDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginStartDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.startDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginStartDevBoxWithModelAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.startDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginStartDevBoxWithModel(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.startDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> stopDevBoxWithResponseAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stopDevBox(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> stopDevBoxWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.stopDevBoxSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginStopDevBoxAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.stopDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginStopDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.stopDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginStopDevBoxWithModelAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.stopDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginStopDevBoxWithModel(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.stopDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BinaryData>> restartDevBoxWithResponseAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restartDevBox(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> restartDevBoxWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.restartDevBoxSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginRestartDevBoxAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.restartDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginRestartDevBox(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.restartDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(BinaryData.class), (TypeReference)TypeReference.createInstance(BinaryData.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginRestartDevBoxWithModelAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.restartDevBoxWithResponseAsync(projectName, userId, devBoxName, requestOptions), (PollingStrategy)new DefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginRestartDevBoxWithModel(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        return SyncPoller.createPoller((Duration)Duration.ofSeconds(1L), () -> this.restartDevBoxWithResponse(projectName, userId, devBoxName, requestOptions), (SyncPollingStrategy)new SyncDefaultPollingStrategy(new PollingStrategyOptions(this.getHttpPipeline()).setEndpoint("{endpoint}".replace("{endpoint}", this.getEndpoint())).setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE).setServiceVersion(this.getServiceVersion().getVersion())), (TypeReference)TypeReference.createInstance(DevCenterOperationDetails.class), (TypeReference)TypeReference.createInstance(Void.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getRemoteConnectionWithResponseAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRemoteConnection(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRemoteConnectionWithResponse(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getRemoteConnectionSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listDevBoxActionsSinglePageAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDevBoxActions(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listDevBoxActionsAsync(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.listDevBoxActionsSinglePageAsync(projectName, userId, devBoxName, requestOptions), nextLink -> this.listDevBoxActionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listDevBoxActionsSinglePage(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listDevBoxActionsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listDevBoxActions(String projectName, String userId, String devBoxName, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.listDevBoxActionsSinglePage(projectName, userId, devBoxName, requestOptions), nextLink -> this.listDevBoxActionsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getDevBoxActionWithResponseAsync(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDevBoxAction(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, actionName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getDevBoxActionWithResponse(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.getDevBoxActionSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, actionName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> skipActionWithResponseAsync(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.skipAction(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, actionName, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> skipActionWithResponse(String projectName, String userId, String devBoxName, String actionName, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.skipActionSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, actionName, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> delayActionWithResponseAsync(String projectName, String userId, String devBoxName, String actionName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delayAction(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, actionName, delayUntil, "application/json", requestOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> delayActionWithResponse(String projectName, String userId, String devBoxName, String actionName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        String accept = "application/json";
        return this.service.delayActionSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, actionName, delayUntil, "application/json", requestOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> delayAllActionsSinglePageAsync(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delayAllActions(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, delayUntil, "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> delayAllActionsAsync(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedFlux(() -> this.delayAllActionsSinglePageAsync(projectName, userId, devBoxName, delayUntil, requestOptions), nextLink -> this.delayAllActionsNextSinglePageAsync((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> delayAllActionsSinglePage(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.delayAllActionsSync(this.getEndpoint(), this.getServiceVersion().getVersion(), projectName, userId, devBoxName, delayUntil, "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> delayAllActions(String projectName, String userId, String devBoxName, OffsetDateTime delayUntil, RequestOptions requestOptions) {
        RequestOptions requestOptionsForNextPage = new RequestOptions();
        requestOptionsForNextPage.setContext(requestOptions != null && requestOptions.getContext() != null ? requestOptions.getContext() : Context.NONE);
        return new PagedIterable(() -> this.delayAllActionsSinglePage(projectName, userId, devBoxName, delayUntil, requestOptions), nextLink -> this.delayAllActionsNextSinglePage((String)nextLink, requestOptionsForNextPage));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listPoolsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPoolsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listPoolsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listPoolsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listSchedulesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSchedulesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listSchedulesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listSchedulesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listAllDevBoxesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllDevBoxesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listAllDevBoxesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listAllDevBoxesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listAllDevBoxesByUserNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAllDevBoxesByUserNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listAllDevBoxesByUserNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listAllDevBoxesByUserNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listDevBoxesNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDevBoxesNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listDevBoxesNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listDevBoxesNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> listDevBoxActionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDevBoxActionsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> listDevBoxActionsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.listDevBoxActionsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BinaryData>> delayAllActionsNextSinglePageAsync(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delayAllActionsNext(nextLink, this.getEndpoint(), "application/json", requestOptions, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<BinaryData> delayAllActionsNextSinglePage(String nextLink, RequestOptions requestOptions) {
        String accept = "application/json";
        Response<BinaryData> res = this.service.delayAllActionsNextSync(nextLink, this.getEndpoint(), "application/json", requestOptions, Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), this.getValues((BinaryData)res.getValue(), "value"), this.getNextLink((BinaryData)res.getValue(), "nextLink"), null);
    }

    private List<BinaryData> getValues(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            List values = (List)obj.get(path);
            return values.stream().map(BinaryData::fromObject).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private String getNextLink(BinaryData binaryData, String path) {
        try {
            Map obj = (Map)binaryData.toObject(Map.class);
            return (String)obj.get(path);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="DevBoxesClient")
    public static interface DevBoxesClientService {
        @Get(value="/projects/{projectName}/pools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPools(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/projects/{projectName}/pools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/projects/{projectName}/pools/{poolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getPool(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="poolName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/projects/{projectName}/pools/{poolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getPoolSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="poolName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/projects/{projectName}/pools/{poolName}/schedules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listSchedules(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="poolName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/projects/{projectName}/pools/{poolName}/schedules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listSchedulesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="poolName") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/projects/{projectName}/pools/{poolName}/schedules/{scheduleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getSchedule(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="poolName") String var4, @PathParam(value="scheduleName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/projects/{projectName}/pools/{poolName}/schedules/{scheduleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getScheduleSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="poolName") String var4, @PathParam(value="scheduleName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/devboxes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listAllDevBoxes(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/devboxes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listAllDevBoxesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="/users/{userId}/devboxes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listAllDevBoxesByUser(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="userId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/users/{userId}/devboxes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listAllDevBoxesByUserSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="userId") String var3, @HeaderParam(value="Accept") String var4, RequestOptions var5, Context var6);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listDevBoxes(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listDevBoxesSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @HeaderParam(value="Accept") String var5, RequestOptions var6, Context var7);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getDevBox(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getDevBoxSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Put(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> createDevBox(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") BinaryData var8, RequestOptions var9, Context var10);

        @Put(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> createDevBoxSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Content-Type") String var6, @HeaderParam(value="Accept") String var7, @BodyParam(value="application/json") BinaryData var8, RequestOptions var9, Context var10);

        @Delete(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> deleteDevBox(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Delete(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}")
        @ExpectedResponses(value={202, 204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> deleteDevBoxSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:start")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> startDevBox(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:start")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> startDevBoxSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:stop")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> stopDevBox(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:stop")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> stopDevBoxSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:restart")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> restartDevBox(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}:restart")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> restartDevBoxSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/remoteConnection")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getRemoteConnection(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/remoteConnection")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getRemoteConnectionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listDevBoxActions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listDevBoxActionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @HeaderParam(value="Accept") String var6, RequestOptions var7, Context var8);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions/{actionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> getDevBoxAction(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @PathParam(value="actionName") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Get(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions/{actionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> getDevBoxActionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @PathParam(value="actionName") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions/{actionName}:skip")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<Void>> skipAction(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @PathParam(value="actionName") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions/{actionName}:skip")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<Void> skipActionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @PathParam(value="actionName") String var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions/{actionName}:delay")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> delayAction(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @PathParam(value="actionName") String var6, @QueryParam(value="until") OffsetDateTime var7, @HeaderParam(value="Accept") String var8, RequestOptions var9, Context var10);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions/{actionName}:delay")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> delayActionSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @PathParam(value="actionName") String var6, @QueryParam(value="until") OffsetDateTime var7, @HeaderParam(value="Accept") String var8, RequestOptions var9, Context var10);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions:delay")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> delayAllActions(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @QueryParam(value="until") OffsetDateTime var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Post(value="/projects/{projectName}/users/{userId}/devboxes/{devBoxName}/actions:delay")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> delayAllActionsSync(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="projectName") String var3, @PathParam(value="userId") String var4, @PathParam(value="devBoxName") String var5, @QueryParam(value="until") OffsetDateTime var6, @HeaderParam(value="Accept") String var7, RequestOptions var8, Context var9);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listPoolsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listPoolsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listSchedulesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listSchedulesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listAllDevBoxesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listAllDevBoxesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listAllDevBoxesByUserNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listAllDevBoxesByUserNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listDevBoxesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listDevBoxesNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> listDevBoxActionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> listDevBoxActionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Mono<Response<BinaryData>> delayAllActionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ClientAuthenticationException.class, code={401}), @UnexpectedResponseExceptionType(value=ResourceNotFoundException.class, code={404}), @UnexpectedResponseExceptionType(value=ResourceModifiedException.class, code={409}), @UnexpectedResponseExceptionType(value=HttpResponseException.class)})
        public Response<BinaryData> delayAllActionsNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, RequestOptions var4, Context var5);
    }
}

