/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.core.models.ResponseError;
import com.azure.developer.devcenter.models.EnvironmentProvisioningState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class DevCenterEnvironment
implements JsonSerializable<DevCenterEnvironment> {
    private Map<String, Object> parameters;
    private String name;
    private final String environmentTypeName;
    private String userId;
    private EnvironmentProvisioningState provisioningState;
    private String resourceGroupId;
    private final String catalogName;
    private final String environmentDefinitionName;
    private ResponseError error;

    public DevCenterEnvironment(String environmentName, String environmentTypeName, String catalogName, String environmentDefinitionName) {
        this.name = environmentName;
        this.environmentTypeName = environmentTypeName;
        this.catalogName = catalogName;
        this.environmentDefinitionName = environmentDefinitionName;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public DevCenterEnvironment setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getEnvironmentTypeName() {
        return this.environmentTypeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public EnvironmentProvisioningState getProvisioningState() {
        return this.provisioningState;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getEnvironmentDefinitionName() {
        return this.environmentDefinitionName;
    }

    public ResponseError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("environmentType", this.environmentTypeName);
        jsonWriter.writeStringField("catalogName", this.catalogName);
        jsonWriter.writeStringField("environmentDefinitionName", this.environmentDefinitionName);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    public static DevCenterEnvironment fromJson(JsonReader jsonReader) throws IOException {
        return (DevCenterEnvironment)jsonReader.readObject(reader -> {
            String name = null;
            String environmentTypeName = null;
            String catalogName = null;
            String environmentDefinitionName = null;
            Map parameters = null;
            String userId = null;
            EnvironmentProvisioningState provisioningState = null;
            String resourceGroupId = null;
            ResponseError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("environmentType".equals(fieldName)) {
                    environmentTypeName = reader.getString();
                    continue;
                }
                if ("catalogName".equals(fieldName)) {
                    catalogName = reader.getString();
                    continue;
                }
                if ("environmentDefinitionName".equals(fieldName)) {
                    environmentDefinitionName = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("user".equals(fieldName)) {
                    userId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    provisioningState = EnvironmentProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGroupId".equals(fieldName)) {
                    resourceGroupId = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            DevCenterEnvironment deserializedDevCenterEnvironment = new DevCenterEnvironment(name, environmentTypeName, catalogName, environmentDefinitionName);
            deserializedDevCenterEnvironment.parameters = parameters;
            deserializedDevCenterEnvironment.userId = userId;
            deserializedDevCenterEnvironment.provisioningState = provisioningState;
            deserializedDevCenterEnvironment.resourceGroupId = resourceGroupId;
            deserializedDevCenterEnvironment.error = error;
            return deserializedDevCenterEnvironment;
        });
    }
}

