/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.developer.devcenter.DeploymentEnvironmentsAsyncClient;
import com.azure.developer.devcenter.DevBoxesAsyncClient;
import com.azure.developer.devcenter.DevCenterClientBuilder;
import com.azure.developer.devcenter.implementation.DeploymentEnvironmentsClientImpl;
import com.azure.developer.devcenter.implementation.DevBoxesClientImpl;
import com.azure.developer.devcenter.implementation.DevCenterClientImpl;
import com.azure.developer.devcenter.models.DevCenterProject;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DevCenterClientBuilder.class, isAsync=true)
public final class DevCenterAsyncClient {
    private final DevCenterClientImpl serviceClient;

    DevCenterAsyncClient(DevCenterClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    public DevBoxesAsyncClient getDevBoxesAsyncClient() {
        return new DevBoxesAsyncClient(new DevBoxesClientImpl(this.serviceClient.getHttpPipeline(), this.serviceClient.getSerializerAdapter(), this.serviceClient.getEndpoint(), this.serviceClient.getServiceVersion()));
    }

    public DeploymentEnvironmentsAsyncClient getDeploymentEnvironmentsAsyncClient() {
        return new DeploymentEnvironmentsAsyncClient(new DeploymentEnvironmentsClientImpl(this.serviceClient.getHttpPipeline(), this.serviceClient.getSerializerAdapter(), this.serviceClient.getEndpoint(), this.serviceClient.getServiceVersion()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listProjects(RequestOptions requestOptions) {
        return this.serviceClient.listProjectsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getProjectWithResponse(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.getProjectWithResponseAsync(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevCenterProject> listProjects() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listProjects(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevCenterProject)protocolMethodData.toObject(DevCenterProject.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevCenterProject> getProject(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getProjectWithResponse(projectName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevCenterProject)protocolMethodData.toObject(DevCenterProject.class));
    }
}

