/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.core.util.CoreUtils;
import com.azure.developer.devcenter.models.DevBoxActionType;
import com.azure.developer.devcenter.models.DevBoxNextAction;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class DevBoxAction
implements JsonSerializable<DevBoxAction> {
    private String name;
    private final DevBoxActionType actionType;
    private final String sourceId;
    private OffsetDateTime suspendedUntil;
    private DevBoxNextAction nextAction;

    private DevBoxAction(DevBoxActionType actionType, String sourceId) {
        this.actionType = actionType;
        this.sourceId = sourceId;
    }

    public String getName() {
        return this.name;
    }

    public DevBoxActionType getActionType() {
        return this.actionType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public OffsetDateTime getSuspendedUntil() {
        return this.suspendedUntil;
    }

    public DevBoxNextAction getNextAction() {
        return this.nextAction;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionType", this.actionType == null ? null : this.actionType.toString());
        jsonWriter.writeStringField("sourceId", this.sourceId);
        jsonWriter.writeStringField("suspendedUntil", this.suspendedUntil == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.suspendedUntil));
        jsonWriter.writeJsonField("next", (JsonSerializable)this.nextAction);
        return jsonWriter.writeEndObject();
    }

    public static DevBoxAction fromJson(JsonReader jsonReader) throws IOException {
        return (DevBoxAction)jsonReader.readObject(reader -> {
            String name = null;
            DevBoxActionType actionType = null;
            String sourceId = null;
            OffsetDateTime suspendedUntil = null;
            DevBoxNextAction nextAction = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("actionType".equals(fieldName)) {
                    actionType = DevBoxActionType.fromString(reader.getString());
                    continue;
                }
                if ("sourceId".equals(fieldName)) {
                    sourceId = reader.getString();
                    continue;
                }
                if ("suspendedUntil".equals(fieldName)) {
                    suspendedUntil = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("next".equals(fieldName)) {
                    nextAction = DevBoxNextAction.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            DevBoxAction deserializedDevBoxAction = new DevBoxAction(actionType, sourceId);
            deserializedDevBoxAction.name = name;
            deserializedDevBoxAction.suspendedUntil = suspendedUntil;
            deserializedDevBoxAction.nextAction = nextAction;
            return deserializedDevBoxAction;
        });
    }
}

