/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.CoreUtils;
import com.azure.data.tables.models.TableServiceGeoReplication;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableServiceStatistics
implements XmlSerializable<TableServiceStatistics> {
    private TableServiceGeoReplication geoReplication;

    public TableServiceStatistics(TableServiceGeoReplication geoReplication) {
        this.geoReplication = geoReplication;
    }

    public TableServiceGeoReplication getGeoReplication() {
        return this.geoReplication;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceStats" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeXml((XmlSerializable)this.geoReplication, "GeoReplication");
        return xmlWriter.writeEndElement();
    }

    public static TableServiceStatistics fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableServiceStatistics.fromXml(xmlReader, null);
    }

    public static TableServiceStatistics fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "StorageServiceStats" : rootElementName;
        return (TableServiceStatistics)xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceStatistics deserializedTableServiceStatistics = new TableServiceStatistics();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("GeoReplication".equals(elementName.getLocalPart())) {
                    deserializedTableServiceStatistics.geoReplication = TableServiceGeoReplication.fromXml(reader, "GeoReplication");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableServiceStatistics;
        });
    }

    private TableServiceStatistics() {
    }
}

