/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.MultipartPart;
import com.azure.data.tables.implementation.models.TransactionalBatchChangeSet;
import com.azure.data.tables.implementation.models.TransactionalBatchSubRequest;

public final class TransactionalBatchRequestBody
extends MultipartPart<Object> {
    private final ClientLogger logger = new ClientLogger(TransactionalBatchRequestBody.class);
    private TransactionalBatchChangeSet changeSet = null;
    private boolean queryAdded = false;

    public TransactionalBatchRequestBody() {
        super("batch");
    }

    public TransactionalBatchRequestBody addQueryOperation(TransactionalBatchSubRequest queryRequest) {
        if (this.changeSet != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot add a query operation to a TransactionalBatchRequestBody containing a changeset."));
        }
        this.addContent(queryRequest);
        this.queryAdded = true;
        return this;
    }

    public TransactionalBatchRequestBody addChangeOperation(TransactionalBatchSubRequest changeRequest) {
        if (this.queryAdded) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot add a change operation to a TransactionalBatchRequestBody containing query operations."));
        }
        if (this.changeSet == null) {
            this.changeSet = new TransactionalBatchChangeSet();
            this.addContent(this.changeSet);
        }
        this.changeSet.addContent(changeRequest);
        return this;
    }
}

