/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosEndToEndOperationLatencyPolicyConfig;
import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.OperationType;
import com.azure.cosmos.implementation.ReplicatedResourceClientUtils;
import com.azure.cosmos.implementation.ResourceType;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.feedranges.FeedRangePartitionKeyImpl;
import com.azure.cosmos.implementation.query.IDocumentQueryClient;
import com.azure.cosmos.implementation.query.IDocumentQueryExecutionContext;
import com.azure.cosmos.implementation.routing.PartitionKeyInternal;
import com.azure.cosmos.implementation.spark.OperationContextAndListenerTuple;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.FeedRange;
import com.azure.cosmos.models.FeedResponse;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.SqlParameter;
import com.azure.cosmos.models.SqlQuerySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionContext<T> {
    private static final ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.CosmosQueryRequestOptionsAccessor qryOptAccessor = ImplementationBridgeHelpers.CosmosQueryRequestOptionsHelper.getCosmosQueryRequestOptionsAccessor();
    private static final ImplementationBridgeHelpers.FeedResponseHelper.FeedResponseAccessor feedResponseAccessor = ImplementationBridgeHelpers.FeedResponseHelper.getFeedResponseAccessor();
    protected final DiagnosticsClientContext diagnosticsClientContext;
    protected ResourceType resourceTypeEnum;
    protected String resourceLink;
    protected IDocumentQueryClient client;
    protected Class<T> resourceType;
    protected CosmosQueryRequestOptions cosmosQueryRequestOptions;
    protected SqlQuerySpec query;
    protected UUID correlatedActivityId;
    protected boolean shouldExecuteQueryRequest;
    private Supplier<String> operationContextTextProvider;
    private final OperationContextAndListenerTuple operationContext;
    private final AtomicBoolean isQueryCancelledOnTimeout;

    protected DocumentQueryExecutionContextBase(DiagnosticsClientContext diagnosticsClientContext, IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, CosmosQueryRequestOptions cosmosQueryRequestOptions, String resourceLink, UUID correlatedActivityId, AtomicBoolean isQueryCancelledOnTimeout) {
        this.client = client;
        this.resourceTypeEnum = resourceTypeEnum;
        this.resourceType = resourceType;
        this.query = query;
        this.shouldExecuteQueryRequest = query != null;
        this.cosmosQueryRequestOptions = cosmosQueryRequestOptions;
        this.resourceLink = resourceLink;
        this.correlatedActivityId = correlatedActivityId;
        this.diagnosticsClientContext = diagnosticsClientContext;
        this.operationContext = qryOptAccessor.getImpl(cosmosQueryRequestOptions).getOperationContextAndListenerTuple();
        this.isQueryCancelledOnTimeout = isQueryCancelledOnTimeout;
        this.operationContextTextProvider = () -> {
            String operationContextText = this.operationContext != null && this.operationContext.getOperationContext() != null ? this.operationContext.getOperationContext().toString() : "n/a";
            this.operationContextTextProvider = () -> operationContextText;
            return operationContextText;
        };
    }

    @Override
    public abstract Flux<FeedResponse<T>> executeAsync();

    public RxDocumentServiceRequest createDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyInternal partitionKey, PartitionKeyDefinition partitionKeyDefinition) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        this.populatePartitionKeyInfo(request, partitionKey, partitionKeyDefinition);
        return request;
    }

    public Supplier<String> getOperationContextTextProvider() {
        return this.operationContextTextProvider;
    }

    protected RxDocumentServiceRequest createDocumentServiceRequestWithFeedRange(Map<String, String> requestHeaders, SqlQuerySpec querySpec, PartitionKeyInternal partitionKeyInternal, FeedRange feedRange, String collectionRid, String throughputControlGroupName) {
        RxDocumentServiceRequest request = querySpec != null ? this.createQueryDocumentServiceRequest(requestHeaders, querySpec) : this.createReadFeedDocumentServiceRequest(requestHeaders);
        request.requestContext.resolvedCollectionRid = collectionRid;
        qryOptAccessor.setCollectionRid(this.cosmosQueryRequestOptions, collectionRid);
        request.setResourceId(collectionRid);
        request.throughputControlGroupName = throughputControlGroupName;
        if (partitionKeyInternal != null) {
            feedRange = new FeedRangePartitionKeyImpl(partitionKeyInternal);
        }
        request.applyFeedRangeFilter(FeedRangeInternal.convert(feedRange));
        CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyConfig = qryOptAccessor.getImpl(this.cosmosQueryRequestOptions).getCosmosEndToEndLatencyPolicyConfig();
        if (endToEndOperationLatencyConfig != null) {
            request.requestContext.setEndToEndOperationLatencyPolicyConfig(endToEndOperationLatencyConfig);
        }
        request.requestContext.setExcludeRegions(qryOptAccessor.getImpl(this.cosmosQueryRequestOptions).getExcludedRegions());
        request.requestContext.setKeywordIdentifiers(qryOptAccessor.getImpl(this.cosmosQueryRequestOptions).getKeywordIdentifiers());
        request.requestContext.setIsRequestCancelledOnTimeout(this.isQueryCancelledOnTimeout);
        return request;
    }

    public Mono<FeedResponse<T>> executeRequestAsync(CosmosItemSerializer itemSerializer, RxDocumentServiceRequest request) {
        return this.shouldExecuteQueryRequest ? this.executeQueryRequestAsync(itemSerializer, request) : this.executeReadFeedRequestAsync(itemSerializer, request);
    }

    public Mono<FeedResponse<T>> executeQueryRequestAsync(CosmosItemSerializer itemSerializer, RxDocumentServiceRequest request) {
        return this.getFeedResponse(itemSerializer, this.executeQueryRequestInternalAsync(request));
    }

    public Mono<FeedResponse<T>> executeReadFeedRequestAsync(CosmosItemSerializer itemSerializer, RxDocumentServiceRequest request) {
        return this.getFeedResponse(itemSerializer, this.client.readFeedAsync(request));
    }

    protected Mono<FeedResponse<T>> getFeedResponse(CosmosItemSerializer itemSerializer, Mono<RxDocumentServiceResponse> response) {
        return response.map(resp -> feedResponseAccessor.createFeedResponse((RxDocumentServiceResponse)resp, itemSerializer, this.resourceType));
    }

    public CosmosQueryRequestOptions getFeedOptions(String continuationToken, Integer maxPageSize) {
        CosmosQueryRequestOptions options = qryOptAccessor.clone(this.cosmosQueryRequestOptions);
        ModelBridgeInternal.setQueryRequestOptionsContinuationTokenAndMaxItemCount(options, continuationToken, maxPageSize);
        return options;
    }

    private Mono<RxDocumentServiceResponse> executeQueryRequestInternalAsync(RxDocumentServiceRequest request) {
        return this.client.executeQueryAsync(request);
    }

    public Map<String, String> createCommonHeadersAsync(CosmosQueryRequestOptions cosmosQueryRequestOptions) {
        String readConsistencyStrategyName;
        UUID correlationActivityId;
        Map<String, String> customOptions;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        ReadConsistencyStrategy requestLevelConsistencyStrategy = cosmosQueryRequestOptions.getReadConsistencyStrategy();
        ConsistencyLevel defaultConsistencyLevel = this.client.getDefaultConsistencyLevelAsync();
        ConsistencyLevel desiredConsistencyLevel = cosmosQueryRequestOptions.getConsistencyLevel() != null ? cosmosQueryRequestOptions.getConsistencyLevel() : this.client.getDesiredConsistencyLevelAsync();
        boolean sessionTokenApplicable = desiredConsistencyLevel == ConsistencyLevel.SESSION || defaultConsistencyLevel == ConsistencyLevel.SESSION && this.resourceTypeEnum == ResourceType.Document;
        if (!Strings.isNullOrEmpty(cosmosQueryRequestOptions.getSessionToken()) && !ReplicatedResourceClientUtils.isReadingFromMaster(this.resourceTypeEnum, OperationType.ReadFeed) && (sessionTokenApplicable &= desiredConsistencyLevel != ConsistencyLevel.EVENTUAL && desiredConsistencyLevel != ConsistencyLevel.CONSISTENT_PREFIX && requestLevelConsistencyStrategy != ReadConsistencyStrategy.EVENTUAL)) {
            requestHeaders.put("x-ms-session-token", cosmosQueryRequestOptions.getSessionToken());
        }
        if ((customOptions = qryOptAccessor.getImpl(cosmosQueryRequestOptions).getHeaders()) != null) {
            requestHeaders.putAll(customOptions);
        }
        if ((correlationActivityId = qryOptAccessor.getImpl(cosmosQueryRequestOptions).getCorrelationActivityId()) != null) {
            requestHeaders.put("x-ms-cosmos-correlated-activityid", correlationActivityId.toString());
        }
        requestHeaders.put("x-ms-continuation", ModelBridgeInternal.getRequestContinuationFromQueryRequestOptions(cosmosQueryRequestOptions));
        requestHeaders.put("x-ms-documentdb-isquery", Strings.toString(true));
        Integer maxItemCount = ModelBridgeInternal.getMaxItemCountFromQueryRequestOptions(cosmosQueryRequestOptions);
        if (maxItemCount != null && maxItemCount > 0) {
            requestHeaders.put("x-ms-max-item-count", Strings.toString(maxItemCount));
        }
        if (cosmosQueryRequestOptions.getMaxDegreeOfParallelism() != 0) {
            requestHeaders.put("x-ms-documentdb-query-parallelizecrosspartitionquery", Strings.toString(true));
        }
        if (this.cosmosQueryRequestOptions.getResponseContinuationTokenLimitInKb() > 0) {
            requestHeaders.put("x-ms-documentdb-responsecontinuationtokenlimitinkb", Strings.toString(cosmosQueryRequestOptions.getResponseContinuationTokenLimitInKb()));
        }
        if (cosmosQueryRequestOptions.isQueryMetricsEnabled()) {
            requestHeaders.put("x-ms-documentdb-populatequerymetrics", String.valueOf(cosmosQueryRequestOptions.isQueryMetricsEnabled()));
        }
        if (cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions() != null) {
            if (cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions().getMaxIntegratedCacheStaleness() != null) {
                requestHeaders.put("x-ms-dedicatedgateway-max-age", String.valueOf(Utils.getMaxIntegratedCacheStalenessInMillis(cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions())));
            }
            if (cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions().isIntegratedCacheBypassed()) {
                requestHeaders.put("x-ms-dedicatedgateway-bypass-cache", String.valueOf(cosmosQueryRequestOptions.getDedicatedGatewayRequestOptions().isIntegratedCacheBypassed()));
            }
        }
        if (cosmosQueryRequestOptions.isIndexMetricsEnabled()) {
            requestHeaders.put("x-ms-cosmos-populateindexmetrics", String.valueOf(cosmosQueryRequestOptions.isIndexMetricsEnabled()));
        }
        boolean consistencyLevelOverrideApplicable = true;
        if (cosmosQueryRequestOptions.getReadConsistencyStrategy() != null) {
            readConsistencyStrategyName = cosmosQueryRequestOptions.getReadConsistencyStrategy().toString();
            this.client.validateAndLogNonDefaultReadConsistencyStrategy(readConsistencyStrategyName);
            requestHeaders.put("x-ms-cosmos-read-consistency-strategy", readConsistencyStrategyName);
            boolean bl = consistencyLevelOverrideApplicable = cosmosQueryRequestOptions.getReadConsistencyStrategy() == ReadConsistencyStrategy.DEFAULT;
        }
        if (consistencyLevelOverrideApplicable && this.client.getReadConsistencyStrategy() != null) {
            readConsistencyStrategyName = this.client.getReadConsistencyStrategy().toString();
            this.client.validateAndLogNonDefaultReadConsistencyStrategy(readConsistencyStrategyName);
            requestHeaders.put("x-ms-cosmos-read-consistency-strategy", readConsistencyStrategyName);
            boolean bl = consistencyLevelOverrideApplicable = this.client.getReadConsistencyStrategy() == ReadConsistencyStrategy.DEFAULT;
        }
        if (consistencyLevelOverrideApplicable && this.client.getConsistencyLevel() != null) {
            requestHeaders.put("x-ms-consistency-level", this.client.getConsistencyLevel().toString());
        }
        return requestHeaders;
    }

    private void populatePartitionKeyInfo(RxDocumentServiceRequest request, PartitionKeyInternal partitionKey, PartitionKeyDefinition partitionKeyDefinition) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (this.resourceTypeEnum.isPartitioned() && partitionKey != null) {
            request.setPartitionKeyInternal(partitionKey);
            request.setPartitionKeyDefinition(partitionKeyDefinition);
            request.getHeaders().put("x-ms-documentdb-partitionkey", partitionKey.toJson());
        }
    }

    private RxDocumentServiceRequest createQueryDocumentServiceRequest(Map<String, String> requestHeaders, SqlQuerySpec querySpec) {
        RxDocumentServiceRequest executeQueryRequest;
        switch (this.client.getQueryCompatibilityMode()) {
            case SqlQuery: {
                List<SqlParameter> params = querySpec.getParameters();
                Utils.checkStateOrThrow(params.size() > 0, "query.parameters", "Unsupported argument in query compatibility mode '%s'", this.client.getQueryCompatibilityMode().toString());
                executeQueryRequest = RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.SqlQuery, this.resourceTypeEnum, this.resourceLink, requestHeaders);
                executeQueryRequest.getHeaders().put("Content-Type", "application/json");
                executeQueryRequest.setContentBytes(Utils.getUTF8Bytes(querySpec.getQueryText()));
                break;
            }
            default: {
                executeQueryRequest = RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.Query, this.resourceTypeEnum, this.resourceLink, requestHeaders);
                CosmosEndToEndOperationLatencyPolicyConfig endToEndOperationLatencyConfig = qryOptAccessor.getImpl(this.cosmosQueryRequestOptions).getCosmosEndToEndLatencyPolicyConfig();
                if (endToEndOperationLatencyConfig != null) {
                    executeQueryRequest.requestContext.setEndToEndOperationLatencyPolicyConfig(endToEndOperationLatencyConfig);
                }
                executeQueryRequest.requestContext.setKeywordIdentifiers(qryOptAccessor.getImpl(this.cosmosQueryRequestOptions).getKeywordIdentifiers());
                executeQueryRequest.setPartitionKeyDefinition(qryOptAccessor.getPartitionKeyDefinition(this.cosmosQueryRequestOptions));
                executeQueryRequest.requestContext.setIsRequestCancelledOnTimeout(this.isQueryCancelledOnTimeout);
                executeQueryRequest.getHeaders().put("Content-Type", "application/query+json");
                executeQueryRequest.setByteBuffer(ModelBridgeInternal.serializeJsonToByteBuffer(querySpec));
            }
        }
        return executeQueryRequest;
    }

    private RxDocumentServiceRequest createReadFeedDocumentServiceRequest(Map<String, String> requestHeaders) {
        if (this.resourceTypeEnum == ResourceType.Database || this.resourceTypeEnum == ResourceType.Offer) {
            return RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.ReadFeed, null, this.resourceTypeEnum, requestHeaders);
        }
        return RxDocumentServiceRequest.create(this.diagnosticsClientContext, OperationType.ReadFeed, this.resourceTypeEnum, this.resourceLink, requestHeaders);
    }
}

