/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.faultinjection;

import com.azure.cosmos.implementation.routing.RegionalRoutingContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class FaultInjectionRequestContext {
    private final Map<String, Integer> hitCountByRuleMap;
    private final Map<Long, String> transportRequestIdRuleIdMap;
    private final Map<Long, List<String>> transportRequestIdRuleEvaluationMap;
    private final AtomicBoolean addressForceRefreshed;
    private volatile URI locationEndpointToRoute;
    private volatile RegionalRoutingContext regionalRoutingContextToRoute;

    public FaultInjectionRequestContext(FaultInjectionRequestContext cloneContext) {
        this.hitCountByRuleMap = cloneContext.hitCountByRuleMap;
        this.transportRequestIdRuleIdMap = new ConcurrentHashMap<Long, String>();
        this.transportRequestIdRuleEvaluationMap = new ConcurrentHashMap<Long, List<String>>();
        this.addressForceRefreshed = new AtomicBoolean(false);
    }

    public FaultInjectionRequestContext() {
        this.hitCountByRuleMap = new ConcurrentHashMap<String, Integer>();
        this.transportRequestIdRuleIdMap = new ConcurrentHashMap<Long, String>();
        this.transportRequestIdRuleEvaluationMap = new ConcurrentHashMap<Long, List<String>>();
        this.addressForceRefreshed = new AtomicBoolean(false);
    }

    public void applyFaultInjectionRule(long transportId, String ruleId) {
        this.hitCountByRuleMap.compute(ruleId, (id, count) -> {
            if (count == null) {
                return 1;
            }
            Integer n = count;
            count = count + 1;
            return count;
        });
        this.transportRequestIdRuleIdMap.put(transportId, ruleId);
    }

    public void recordFaultInjectionRuleEvaluation(long transportId, String ruleEvaluationResult) {
        this.transportRequestIdRuleEvaluationMap.compute(transportId, (id, evaluations) -> {
            if (evaluations == null) {
                evaluations = new ArrayList<String>();
            }
            evaluations.add(ruleEvaluationResult);
            return evaluations;
        });
    }

    public void recordAddressForceRefreshed(boolean forceRefreshed) {
        if (forceRefreshed) {
            this.addressForceRefreshed.compareAndSet(false, true);
        }
    }

    public boolean getAddressForceRefreshed() {
        return this.addressForceRefreshed.get();
    }

    public int getFaultInjectionRuleApplyCount(String ruleId) {
        if (this.hitCountByRuleMap.isEmpty()) {
            return 0;
        }
        return this.hitCountByRuleMap.getOrDefault(ruleId, 0);
    }

    public String getFaultInjectionRuleId(long transportRequestId) {
        if (this.transportRequestIdRuleIdMap.isEmpty()) {
            return null;
        }
        return this.transportRequestIdRuleIdMap.getOrDefault(transportRequestId, null);
    }

    public void setLocationEndpointToRoute(URI locationEndpointToRoute) {
        this.locationEndpointToRoute = locationEndpointToRoute;
        this.regionalRoutingContextToRoute = new RegionalRoutingContext(locationEndpointToRoute);
    }

    public URI getLocationEndpointToRoute() {
        return this.locationEndpointToRoute;
    }

    public List<String> getFaultInjectionRuleEvaluationResults(long transportRequestId) {
        if (this.transportRequestIdRuleEvaluationMap.isEmpty()) {
            return null;
        }
        return this.transportRequestIdRuleEvaluationMap.getOrDefault(transportRequestId, null);
    }
}

