/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.BridgeInternal;
import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosContainerProactiveInitConfig;
import com.azure.cosmos.ReadConsistencyStrategy;
import com.azure.cosmos.implementation.BadRequestException;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.RxDocumentServiceResponse;
import com.azure.cosmos.implementation.RxStoreModel;
import com.azure.cosmos.implementation.Strings;
import com.azure.cosmos.implementation.directconnectivity.ReplicatedResourceClient;
import com.azure.cosmos.implementation.directconnectivity.StoreClient;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.implementation.throughputControl.ThroughputControlStore;
import com.azure.cosmos.models.CosmosContainerIdentity;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerStoreModel
implements RxStoreModel {
    private final StoreClient storeClient;

    public ServerStoreModel(StoreClient storeClient) {
        this.storeClient = storeClient;
    }

    @Override
    public Mono<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        String requestConsistencyLevelHeaderValue = request.getHeaders().get("x-ms-consistency-level");
        String requestReadConsistencyStrategyHeaderValue = request.getHeaders().get("x-ms-cosmos-read-consistency-strategy");
        request.requestContext.originalRequestConsistencyLevel = null;
        request.requestContext.readConsistencyStrategy = ReadConsistencyStrategy.DEFAULT;
        if (!Strings.isNullOrEmpty(requestConsistencyLevelHeaderValue)) {
            ConsistencyLevel requestConsistencyLevel = BridgeInternal.fromServiceSerializedFormat(requestConsistencyLevelHeaderValue);
            if (requestConsistencyLevel == null) {
                return Mono.error((Throwable)((Object)new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-consistency-level"))));
            }
            request.requestContext.originalRequestConsistencyLevel = requestConsistencyLevel;
        }
        if (!Strings.isNullOrEmpty(requestReadConsistencyStrategyHeaderValue)) {
            ReadConsistencyStrategy requestReadConsistencyStrategy = ImplementationBridgeHelpers.ReadConsistencyStrategyHelper.getReadConsistencyStrategyAccessor().createFromServiceSerializedFormat(requestReadConsistencyStrategyHeaderValue);
            if (requestReadConsistencyStrategy == null) {
                return Mono.error((Throwable)((Object)new BadRequestException(String.format("Value '%s' specified for the header '%s' is invalid.", requestConsistencyLevelHeaderValue, "x-ms-cosmos-read-consistency-strategy"))));
            }
            request.requestContext.readConsistencyStrategy = requestReadConsistencyStrategy;
        }
        if (ReplicatedResourceClient.isMasterResource(request.getResourceType())) {
            request.getHeaders().put("x-ms-consistency-level", ConsistencyLevel.STRONG.toString());
        }
        return this.storeClient.processMessageAsync(request);
    }

    @Override
    public void enableThroughputControl(ThroughputControlStore throughputControlStore) {
        this.storeClient.enableThroughputControl(throughputControlStore);
    }

    @Override
    public Flux<Void> submitOpenConnectionTasksAndInitCaches(CosmosContainerProactiveInitConfig proactiveContainerInitConfig) {
        return this.storeClient.submitOpenConnectionTasksAndInitCaches(proactiveContainerInitConfig);
    }

    @Override
    public void configureFaultInjectorProvider(IFaultInjectorProvider injectorProvider, Configs configs) {
        this.storeClient.configureFaultInjectorProvider(injectorProvider);
    }

    @Override
    public void recordOpenConnectionsAndInitCachesCompleted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.storeClient.recordOpenConnectionsAndInitCachesCompleted(cosmosContainerIdentities);
    }

    @Override
    public void recordOpenConnectionsAndInitCachesStarted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.storeClient.recordOpenConnectionsAndInitCachesStarted(cosmosContainerIdentities);
    }
}

