/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.JsonSerializable;
import com.azure.cosmos.implementation.ObjectNodeMap;
import com.azure.cosmos.implementation.PrimitiveJsonNodeMap;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;

public class DefaultCosmosItemSerializer
extends CosmosItemSerializer {
    ImplementationBridgeHelpers.CosmosItemSerializerHelper.CosmosItemSerializerAccessor itemSerializerAccessor = ImplementationBridgeHelpers.CosmosItemSerializerHelper.getCosmosItemSerializerAccessor();
    private static final ObjectMapper serializationInclusionModeAwareObjectMapper = Utils.getDocumentObjectMapper(Configs.getItemSerializationInclusionMode());
    private static final ObjectMapper defaultSerializationInclusionModeObjectMapper = Utils.getSimpleObjectMapper();
    public static final CosmosItemSerializer DEFAULT_SERIALIZER = new DefaultCosmosItemSerializer(serializationInclusionModeAwareObjectMapper);
    public static final CosmosItemSerializer INTERNAL_DEFAULT_SERIALIZER = new DefaultCosmosItemSerializer(defaultSerializationInclusionModeObjectMapper);
    private final ObjectMapper mapper;

    public DefaultCosmosItemSerializer(ObjectMapper mapper) {
        Preconditions.checkNotNull("mapper", "Argument 'mapper' must not be null.");
        this.mapper = mapper;
        this.itemSerializerAccessor.setItemObjectMapper(this, mapper);
        this.itemSerializerAccessor.setShouldWrapSerializationExceptions(this, false);
    }

    @Override
    public <T> Map<String, Object> serialize(T item) {
        if (item == null) {
            return null;
        }
        if (item instanceof ObjectNode) {
            return new ObjectNodeMap((ObjectNode)item);
        }
        if (item instanceof JsonSerializable) {
            return ((JsonSerializable)item).getMap();
        }
        JsonNode jsonNode = (JsonNode)this.mapper.convertValue(item, JsonNode.class);
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isObject()) {
            return new ObjectNodeMap((ObjectNode)jsonNode);
        }
        return new PrimitiveJsonNodeMap(jsonNode);
    }

    @Override
    public <T> T deserialize(Map<String, Object> jsonNodeMap, Class<T> classType) {
        if (jsonNodeMap == null) {
            return null;
        }
        ObjectNode jsonNode = null;
        try {
            if (jsonNodeMap instanceof ObjectNodeMap) {
                jsonNode = ((ObjectNodeMap)jsonNodeMap).getObjectNode();
            } else {
                if (jsonNodeMap instanceof PrimitiveJsonNodeMap) {
                    return (T)this.mapper.convertValue((Object)((PrimitiveJsonNodeMap)jsonNodeMap).getPrimitiveJsonNode(), classType);
                }
                jsonNode = (ObjectNode)this.mapper.convertValue(jsonNodeMap, ObjectNode.class);
            }
            if (JsonSerializable.class.isAssignableFrom(classType)) {
                return (T)JsonSerializable.instantiateFromObjectNodeAndType(jsonNode, classType);
            }
            return (T)this.mapper.treeToValue((TreeNode)jsonNode, classType);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to parse JSON %s as %s", jsonNode, classType.getName()), e);
        }
    }
}

