/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.guava25.collect.ImmutableMap;
import java.util.Map;

public final class CosmosDiagnosticsSystemUsageSnapshot {
    private final String usedMemory;
    private final String availableMemory;
    private final String systemCpuLoad;
    private final int availableProcessors;
    private final ImmutableMap<String, Object> map;

    public CosmosDiagnosticsSystemUsageSnapshot(String systemCpuLoad, String usedMemory, String availableMemory, int availableProcessors) {
        Preconditions.checkNotNull(systemCpuLoad, "Argument 'systemCpuLoad' must not be null.");
        Preconditions.checkNotNull(usedMemory, "Argument 'usedMemory' must not be null.");
        Preconditions.checkNotNull(availableMemory, "Argument 'availableMemory' must not be null.");
        this.systemCpuLoad = systemCpuLoad;
        this.usedMemory = usedMemory;
        this.availableMemory = availableMemory;
        this.availableProcessors = availableProcessors;
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builderWithExpectedSize(4);
        builder.put("CPU", systemCpuLoad);
        builder.put("Memory used", usedMemory);
        builder.put("Memory available", availableMemory);
        builder.put("Processor count", availableProcessors);
        this.map = builder.build();
    }

    public String getUsedMemory() {
        return this.usedMemory;
    }

    public String getAvailableMemory() {
        return this.availableMemory;
    }

    public String getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public Map<String, Object> toMap() {
        return this.map;
    }
}

