/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.util.Beta;

@Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
public class Http2ConnectionConfig {
    private Integer maxConnectionPoolSize;
    private Integer minConnectionPoolSize;
    private Integer maxConcurrentStreams;
    private Boolean enabled;

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Http2ConnectionConfig() {
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Integer getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    int getEffectiveMaxConnectionPoolSize() {
        Integer snapshot = this.maxConnectionPoolSize;
        return snapshot != null ? snapshot : Configs.getHttp2MaxConnectionPoolSize();
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Http2ConnectionConfig setMaxConnectionPoolSize(Integer maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Integer getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    int getEffectiveMaxConcurrentStreams() {
        Integer snapshot = this.maxConcurrentStreams;
        return snapshot != null ? snapshot : Configs.getHttp2MaxConcurrentStreams();
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Http2ConnectionConfig setMaxConcurrentStreams(Integer maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Integer getMinConnectionPoolSize() {
        return this.minConnectionPoolSize;
    }

    int getEffectiveMinConnectionPoolSize() {
        Integer snapshot = this.minConnectionPoolSize;
        return snapshot != null ? snapshot : Configs.getHttp2MinConnectionPoolSize();
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Http2ConnectionConfig setMinConnectionPoolSize(Integer minConnectionPoolSize) {
        this.minConnectionPoolSize = minConnectionPoolSize;
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Boolean isEnabled() {
        return this.enabled;
    }

    boolean isEffectivelyEnabled() {
        Boolean snapshot = this.enabled;
        return snapshot != null ? snapshot : Configs.isHttp2Enabled();
    }

    @Beta(value=Beta.SinceVersion.V4_69_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public Http2ConnectionConfig setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    String toDiagnosticsString() {
        return String.format("(enabled:%s, maxc:%s, minc:%s, maxs:%s)", this.isEffectivelyEnabled(), this.getEffectiveMaxConnectionPoolSize(), this.getEffectiveMinConnectionPoolSize(), this.getEffectiveMaxConcurrentStreams());
    }

    static void initialize() {
        ImplementationBridgeHelpers.Http2ConnectionConfigHelper.setHttp2ConnectionConfigAccessor(new ImplementationBridgeHelpers.Http2ConnectionConfigHelper.Http2ConnectionConfigAccessor(){

            @Override
            public String toDiagnosticsString(Http2ConnectionConfig cfg) {
                return cfg.toDiagnosticsString();
            }

            @Override
            public int getEffectiveMaxConcurrentStreams(Http2ConnectionConfig cfg) {
                return cfg.getEffectiveMaxConcurrentStreams();
            }

            @Override
            public int getEffectiveMaxConnectionPoolSize(Http2ConnectionConfig cfg) {
                return cfg.getEffectiveMaxConnectionPoolSize();
            }

            @Override
            public int getEffectiveMinConnectionPoolSize(Http2ConnectionConfig cfg) {
                return cfg.getEffectiveMinConnectionPoolSize();
            }

            @Override
            public boolean isEffectivelyEnabled(Http2ConnectionConfig cfg) {
                return cfg.isEffectivelyEnabled();
            }
        });
    }

    static {
        Http2ConnectionConfig.initialize();
    }
}

