/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.routing;

import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.routing.IPartitionKeyComponent;
import com.azure.cosmos.implementation.routing.PartitionKeyComponentType;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;

public class NumberPartitionKeyComponent
implements IPartitionKeyComponent {
    public static final NumberPartitionKeyComponent Zero = new NumberPartitionKeyComponent(0.0);
    private final double value;

    public NumberPartitionKeyComponent(double value) {
        this.value = value;
    }

    private static byte[] doubleToByteArray(double d) {
        byte[] output = new byte[8];
        long lng = Double.doubleToLongBits(d);
        for (int i = 0; i < 8; ++i) {
            output[i] = (byte)(lng >> i * 8 & 0xFFL);
        }
        return output;
    }

    private static long encodeDoubleAsUInt64(double value) {
        long mask;
        long rawLongBits = Double.doubleToRawLongBits(value);
        return Long.compareUnsigned(rawLongBits, mask = Long.MIN_VALUE) < 0 ? rawLongBits ^ mask : (rawLongBits ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
    }

    @Override
    public int compareTo(IPartitionKeyComponent other) {
        NumberPartitionKeyComponent otherBool = Utils.as(other, NumberPartitionKeyComponent.class);
        if (otherBool == null) {
            throw new IllegalArgumentException("other");
        }
        return Double.compare(this.value, ((NumberPartitionKeyComponent)other).value);
    }

    @Override
    public int getTypeOrdinal() {
        return PartitionKeyComponentType.NUMBER.type;
    }

    @Override
    public void jsonEncode(JsonGenerator writer) {
        try {
            writer.writeNumber(String.valueOf(this.value));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeForHashing(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.NUMBER.type);
            outputStream.write(NumberPartitionKeyComponent.doubleToByteArray(this.value));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeForHashingV2(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.NUMBER.type);
            outputStream.write(NumberPartitionKeyComponent.doubleToByteArray(this.value));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeForBinaryEncoding(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.NUMBER.type);
            long payload = NumberPartitionKeyComponent.encodeDoubleAsUInt64(this.value);
            outputStream.write((byte)(payload >> 56));
            payload <<= 8;
            int byteToWrite = 0;
            boolean firstIteration = true;
            do {
                if (!firstIteration) {
                    outputStream.write(byteToWrite);
                } else {
                    firstIteration = false;
                }
                byteToWrite = (byte)(payload >> 56 | 1L);
            } while ((payload <<= 7) != 0L);
            outputStream.write((byte)(byteToWrite & 0xFE));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IPartitionKeyComponent truncate() {
        return this;
    }

    @Override
    public Object toObject() {
        return this.value;
    }
}

