/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query.orderbyquery;

import com.azure.cosmos.implementation.query.ItemComparator;
import com.azure.cosmos.implementation.query.QueryItem;
import com.azure.cosmos.implementation.query.SortOrder;
import com.azure.cosmos.implementation.query.orderbyquery.OrderByRowResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderbyRowComparer<T>
implements Comparator<OrderByRowResult<T>>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(OrderbyRowComparer.class);
    private static final long serialVersionUID = 7296627879628897315L;
    private final List<SortOrder> sortOrders;

    public OrderbyRowComparer(Collection<SortOrder> sortOrders) {
        this.sortOrders = new ArrayList<SortOrder>(sortOrders);
    }

    @Override
    public int compare(OrderByRowResult<T> r1, OrderByRowResult<T> r2) {
        try {
            List<QueryItem> result1 = r1.getOrderByItems();
            List<QueryItem> result2 = r2.getOrderByItems();
            if (result1.size() != result2.size()) {
                throw new IllegalStateException("OrderByItems cannot have different sizes.");
            }
            if (result1.size() != this.sortOrders.size()) {
                throw new IllegalStateException("OrderByItems cannot have a different size than sort orders.");
            }
            for (int i = 0; i < result1.size(); ++i) {
                int cmp = ItemComparator.getInstance().compare(result1.get(i).getItem(), result2.get(i).getItem());
                if (cmp == 0) continue;
                switch (this.sortOrders.get(i)) {
                    case Ascending: {
                        return Integer.signum(cmp);
                    }
                    case Descending: {
                        return -Integer.signum(cmp);
                    }
                }
            }
            return r1.getSourceRange().getRange().getMin().compareTo(r2.getSourceRange().getRange().getMin());
        }
        catch (Exception e) {
            logger.error("Orderby Row comparison failed {}, {}", new Object[]{r1.toJson(), r2.toJson(), e});
            throw e;
        }
    }

    public List<SortOrder> getSortOrders() {
        return this.sortOrders;
    }
}

