/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.query;

import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.implementation.query.DistinctHash;
import com.azure.cosmos.implementation.query.DistinctMap;
import com.azure.cosmos.implementation.routing.UInt128;
import java.io.IOException;

public class OrderedDistinctMap
extends DistinctMap {
    private volatile UInt128 lastHash;

    public OrderedDistinctMap(UInt128 lastHash) {
        this.lastHash = lastHash;
    }

    @Override
    public boolean add(Object resource, Utils.ValueHolder<UInt128> outHash) {
        try {
            if (resource instanceof Resource) {
                resource = this.getSortedJsonStringValueFromResource((Resource)resource);
            }
            outHash.v = DistinctHash.getHash(resource);
            boolean value = true;
            if (this.lastHash != null) {
                value = !((UInt128)outHash.v).equals(this.lastHash);
            }
            this.lastHash = (UInt128)outHash.v;
            return value;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to add value to distinct map", e);
        }
    }
}

